package org.starcoin.types.event;


import org.starcoin.types.AccountAddress;

public final class ProposalCreatedEvent {
    public final @com.novi.serde.Unsigned Long proposal_id;
    public final AccountAddress proposer;

    public ProposalCreatedEvent(@com.novi.serde.Unsigned Long proposal_id, AccountAddress proposer) {
        java.util.Objects.requireNonNull(proposal_id, "proposal_id must not be null");
        java.util.Objects.requireNonNull(proposer, "proposer must not be null");
        this.proposal_id = proposal_id;
        this.proposer = proposer;
    }

    public static ProposalCreatedEvent deserialize(com.novi.serde.Deserializer deserializer) throws com.novi.serde.DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.proposal_id = deserializer.deserialize_u64();
        builder.proposer = AccountAddress.deserialize(deserializer);
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static ProposalCreatedEvent bcsDeserialize(byte[] input) throws com.novi.serde.DeserializationError {
        if (input == null) {
            throw new com.novi.serde.DeserializationError("Cannot deserialize null array");
        }
        com.novi.serde.Deserializer deserializer = new com.novi.bcs.BcsDeserializer(input);
        ProposalCreatedEvent value = deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new com.novi.serde.DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public void serialize(com.novi.serde.Serializer serializer) throws com.novi.serde.SerializationError {
        serializer.increase_container_depth();
        serializer.serialize_u64(proposal_id);
        proposer.serialize(serializer);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws com.novi.serde.SerializationError {
        com.novi.serde.Serializer serializer = new com.novi.bcs.BcsSerializer();
        serialize(serializer);
        return serializer.get_bytes();
    }

    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null) return false;
        if (getClass() != obj.getClass()) return false;
        ProposalCreatedEvent other = (ProposalCreatedEvent) obj;
        if (!java.util.Objects.equals(this.proposal_id, other.proposal_id)) {
            return false;
        }
        if (!java.util.Objects.equals(this.proposer, other.proposer)) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.proposal_id != null ? this.proposal_id.hashCode() : 0);
        value = 31 * value + (this.proposer != null ? this.proposer.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public @com.novi.serde.Unsigned Long proposal_id;
        public AccountAddress proposer;

        public ProposalCreatedEvent build() {
            return new ProposalCreatedEvent(
                    proposal_id,
                    proposer
            );
        }
    }
}
