/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.api;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.starcoin.api.JsonRPCClient;
import org.starcoin.bean.Event;
import org.starcoin.bean.GetEventOption;
import org.starcoin.bean.GetTransactionOption;
import org.starcoin.bean.PendingTransaction;
import org.starcoin.bean.Transaction;
import org.starcoin.bean.TransactionInfoWithProof;
import org.starcoin.jsonrpc.client.JSONRPC2Session;
import org.starcoin.jsonrpc.client.JSONRPC2SessionException;

public class TransactionRPCClient {
    private static final Logger log = LoggerFactory.getLogger(TransactionRPCClient.class);
    JSONRPC2Session session;

    public TransactionRPCClient(URL baseUrl) {
        this.session = new JSONRPC2Session(baseUrl);
    }

    public PendingTransaction getPendingTransaction(String hash) throws JSONRPC2SessionException {
        JsonRPCClient<PendingTransaction> client = new JsonRPCClient<PendingTransaction>();
        return client.getObject(this.session, "txpool.pending_txn", Collections.singletonList(hash), 0, PendingTransaction.class);
    }

    public Transaction getTransactionByHash(String hash) throws JSONRPC2SessionException {
        JsonRPCClient<Transaction> client = new JsonRPCClient<Transaction>();
        ArrayList<Object> parameter = new ArrayList<Object>();
        parameter.add(hash);
        GetTransactionOption option = new GetTransactionOption();
        option.setDecode(true);
        parameter.add(option);
        return client.getObject(this.session, "chain.get_transaction", parameter, 0, Transaction.class);
    }

    public Transaction getTransactionInfoByHash(String hash) throws JSONRPC2SessionException {
        JsonRPCClient<Transaction> client = new JsonRPCClient<Transaction>();
        return client.getObject(this.session, "chain.get_transaction_info", Collections.singletonList(hash), 0, Transaction.class);
    }

    public List<Transaction> getTransactionInfos(long startGlobalIndex, boolean reverse, int count) throws JSONRPC2SessionException {
        JsonRPCClient<Transaction> client = new JsonRPCClient<Transaction>();
        ArrayList<Object> parameter = new ArrayList<Object>();
        parameter.add(startGlobalIndex);
        parameter.add(reverse);
        parameter.add(count);
        return client.getObjectArray(this.session, "chain.get_transaction_infos", parameter, 0, Transaction.class);
    }

    public List<Transaction> getBlockTransactions(String blockHash) throws JSONRPC2SessionException {
        JsonRPCClient<Transaction> client = new JsonRPCClient<Transaction>();
        return client.getObjectArray(this.session, "chain.get_block_txn_infos", Collections.singletonList(blockHash), 0, Transaction.class);
    }

    public List<Event> getTransactionEvents(String transactionHash) throws JSONRPC2SessionException {
        JsonRPCClient<Event> client = new JsonRPCClient<Event>();
        return client.getObjectArray(this.session, "chain.get_events_by_txn_hash", Collections.singletonList(transactionHash), 0, Event.class);
    }

    public List<Event> getEvents(Long fromBlock, Long toBlock, List<String> eventKeys, List<String> accountAddress, List<String> typeTags, Integer limit) throws JSONRPC2SessionException {
        JsonRPCClient<Event> client = new JsonRPCClient<Event>();
        ArrayList<Object> parameter = new ArrayList<Object>();
        HashMap<String, Object> mapParameter = new HashMap<String, Object>();
        mapParameter.put("from_block", fromBlock);
        mapParameter.put("to_block", toBlock);
        mapParameter.put("event_keys", eventKeys);
        mapParameter.put("addrs", accountAddress);
        mapParameter.put("type_tags", typeTags);
        mapParameter.put("limit", limit);
        parameter.add(mapParameter);
        parameter.add(new GetEventOption(true));
        return client.getObjectArray(this.session, "chain.get_events", parameter, 0, Event.class);
    }

    public Transaction getTransactionInfoByBlockAndIndex(String blockHash, int transactionIndex) throws JSONRPC2SessionException {
        JsonRPCClient<Transaction> client = new JsonRPCClient<Transaction>();
        ArrayList<Object> parameter = new ArrayList<Object>();
        parameter.add(blockHash);
        parameter.add(transactionIndex);
        return client.getObject(this.session, "chain.get_txn_info_by_block_and_index", parameter, 0, Transaction.class);
    }

    public TransactionInfoWithProof getTransactionProof(String blockHash, long transactionGlobalIndex) throws JSONRPC2SessionException {
        JsonRPCClient<TransactionInfoWithProof> client = new JsonRPCClient<TransactionInfoWithProof>();
        ArrayList<Object> parameter = new ArrayList<Object>();
        parameter.add(blockHash);
        parameter.add(transactionGlobalIndex);
        return client.getObject(this.session, "chain.get_transaction_proof", parameter, 0, TransactionInfoWithProof.class);
    }

    public TransactionInfoWithProof getTransactionProof(String blockHash, long transactionGlobalIndex, int eventIndex) throws JSONRPC2SessionException {
        JsonRPCClient<TransactionInfoWithProof> client = new JsonRPCClient<TransactionInfoWithProof>();
        ArrayList<Object> parameter = new ArrayList<Object>();
        parameter.add(blockHash);
        parameter.add(transactionGlobalIndex);
        parameter.add(eventIndex);
        return client.getObject(this.session, "chain.get_transaction_proof", parameter, 0, TransactionInfoWithProof.class);
    }

    public TransactionInfoWithProof getTransactionProof(String blockHash, long transactionGlobalIndex, int eventIndex, String accessPath) throws JSONRPC2SessionException {
        JsonRPCClient<TransactionInfoWithProof> client = new JsonRPCClient<TransactionInfoWithProof>();
        ArrayList<Object> parameter = new ArrayList<Object>();
        parameter.add(blockHash);
        parameter.add(transactionGlobalIndex);
        parameter.add(eventIndex);
        parameter.add(accessPath);
        return client.getObject(this.session, "chain.get_transaction_proof", parameter, 0, TransactionInfoWithProof.class);
    }
}

