/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.bean;

import com.alibaba.fastjson.annotation.JSONField;
import com.novi.bcs.BcsDeserializer;
import com.novi.serde.DeserializationError;
import java.math.BigInteger;
import org.starcoin.bean.Base;
import org.starcoin.utils.Hex;

public class Transfer
extends Base {
    long timestamp;
    String identifier;
    @JSONField(name="txn_hash")
    String txnHash;
    @JSONField(name="sender")
    String sender;
    @JSONField(name="receiver")
    String receiver;
    @JSONField(name="amount")
    String amount;
    @JSONField(name="amount_value")
    BigInteger amountValue;
    @JSONField(name="type_tag")
    String typeTag;

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getTxnHash() {
        return this.txnHash;
    }

    public void setTxnHash(String txnHash) {
        this.txnHash = txnHash;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public void setReceiver(String receiver) {
        this.receiver = receiver;
    }

    public String getAmount() {
        return this.amount;
    }

    public void setAmount(String amount) {
        this.amount = amount;
    }

    public String getTypeTag() {
        return this.typeTag;
    }

    public void setTypeTag(String typeTag) {
        this.typeTag = typeTag;
    }

    public BigInteger getAmountValue() {
        try {
            return new BcsDeserializer(Hex.decode(this.amount)).deserialize_u128();
        }
        catch (DeserializationError deserializationError) {
            deserializationError.printStackTrace();
            return BigInteger.ZERO;
        }
    }

    public void setAmountValue(BigInteger amountValue) {
        this.amountValue = amountValue;
    }

    private long transferAmount(String amountStr) {
        if (amountStr == null && !amountStr.startsWith("0x")) {
            return 0L;
        }
        int len = amountStr.length();
        int index = 0;
        for (int i = len - 1; i > 1; --i) {
            if (amountStr.charAt(i) == '0') continue;
            index = i;
            break;
        }
        try {
            if (index + 1 > 2) {
                String tempStr = amountStr.substring(2, index + 1);
                return Long.parseLong(tempStr, 16);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public String toString() {
        return "Transfer{timestamp=" + this.timestamp + ", identifier='" + this.identifier + '\'' + ", txnHash='" + this.txnHash + '\'' + ", sender='" + this.sender + '\'' + ", receiver='" + this.receiver + '\'' + ", amount='" + this.amount + '\'' + ", typeTag='" + this.typeTag + '\'' + '}';
    }
}

