/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.serde.format.jackson;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.util.ArrayList;
import org.starcoin.serde.format.Format;

public class FormatDeserializer
extends JsonDeserializer<Format> {
    public Format deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectCodec oc = p.getCodec();
        JsonNode node = (JsonNode)oc.readTree(p);
        if (node instanceof TextNode) {
            return Format.Primitive.valueOf(node.textValue());
        }
        if (node instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)node;
            String firstFieldName = (String)objectNode.fieldNames().next();
            if ("TYPENAME".equals(firstFieldName)) {
                TextNode textNode = (TextNode)objectNode.get(firstFieldName);
                return new Format.TypeName(textNode.asText());
            }
            if ("OPTION".equals(firstFieldName)) {
                JsonNode formatNode = objectNode.get(firstFieldName);
                return new Format.Option((Format)oc.treeToValue((TreeNode)formatNode, Format.class));
            }
            if ("SEQ".equals(firstFieldName)) {
                JsonNode formatNode = objectNode.get(firstFieldName);
                return new Format.Seq((Format)oc.treeToValue((TreeNode)formatNode, Format.class));
            }
            if ("MAP".equals(firstFieldName)) {
                ObjectNode kvFormatNode = (ObjectNode)objectNode.get(firstFieldName);
                Format keyFormat = (Format)oc.treeToValue((TreeNode)kvFormatNode.get("KEY"), Format.class);
                Format valueFormat = (Format)oc.treeToValue((TreeNode)kvFormatNode.get("VALUE"), Format.class);
                return new Format.Map(keyFormat, valueFormat);
            }
            if ("TUPLE".equals(firstFieldName)) {
                ArrayNode formatsNode = (ArrayNode)objectNode.get(firstFieldName);
                ArrayList<Format> formats = new ArrayList<Format>();
                for (JsonNode formatNode : formatsNode) {
                    formats.add((Format)oc.treeToValue((TreeNode)formatNode, Format.class));
                }
                return new Format.Tuple(formats);
            }
            if ("TUPLEARRAY".equals(firstFieldName)) {
                ObjectNode czNode = (ObjectNode)objectNode.get(firstFieldName);
                Format contentFormat = (Format)oc.treeToValue((TreeNode)czNode.get("CONTENT"), Format.class);
                int size = Integer.valueOf(czNode.get("SIZE").asText());
                return new Format.TupleArray(contentFormat, size);
            }
        }
        throw new JsonParseException(p, "Unknown node type.");
    }
}

