/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.stdlib;

import com.novi.bcs.BcsSerializer;
import com.novi.serde.Bytes;
import com.novi.serde.Int128;
import com.novi.serde.SerializationError;
import com.novi.serde.Unsigned;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.starcoin.types.AccountAddress;
import org.starcoin.types.Identifier;
import org.starcoin.types.ModuleId;
import org.starcoin.types.ScriptFunction;
import org.starcoin.types.TransactionPayload;
import org.starcoin.utils.AccountAddressUtils;

public class ExtHelpers {
    private ExtHelpers() {
    }

    public static TransactionPayload encode_empty_args_script_function(String moduleId, String functionName) {
        return ExtHelpers.buildScriptFunctionTransactionPayload(moduleId, functionName, Collections.emptyList());
    }

    public static TransactionPayload encode_u8_script_function(String moduleId, String functionName, Byte b) {
        return ExtHelpers.buildScriptFunctionTransactionPayload(moduleId, functionName, Collections.singletonList(ExtHelpers.encode_u8_argument(b)));
    }

    public static TransactionPayload encode_u64_script_function(String moduleId, String functionName, Long l) {
        return ExtHelpers.buildScriptFunctionTransactionPayload(moduleId, functionName, Collections.singletonList(ExtHelpers.encode_u64_argument(l)));
    }

    public static TransactionPayload encode_u128_script_function(String moduleId, String functionName, BigInteger i) {
        return ExtHelpers.buildScriptFunctionTransactionPayload(moduleId, functionName, Collections.singletonList(ExtHelpers.encode_u128_argument(i)));
    }

    public static TransactionPayload encode_bool_script_function(String moduleId, String functionName, Boolean b) {
        return ExtHelpers.buildScriptFunctionTransactionPayload(moduleId, functionName, Collections.singletonList(ExtHelpers.encode_bool_argument(b)));
    }

    public static TransactionPayload encode_u64_and_u8_script_function(String moduleId, String functionName, Long u64, Byte u8) {
        return ExtHelpers.buildScriptFunctionTransactionPayload(moduleId, functionName, Arrays.asList(ExtHelpers.encode_u64_argument(u64), ExtHelpers.encode_u8_argument(u8)));
    }

    public static TransactionPayload encode_u8vector_script_function(String moduleId, String functionName, Bytes bytes) {
        List<Bytes> args = Arrays.asList(ExtHelpers.encode_u8vector_argument(bytes));
        return ExtHelpers.buildScriptFunctionTransactionPayload(moduleId, functionName, args);
    }

    public static TransactionPayload encode_u8vector_and_u64_and_bool_script_function(String moduleId, String functionName, Bytes bytes, Long u64, Boolean b) {
        List<Bytes> args = Arrays.asList(ExtHelpers.encode_u8vector_argument(bytes), ExtHelpers.encode_u64_argument(u64), ExtHelpers.encode_bool_argument(b));
        return ExtHelpers.buildScriptFunctionTransactionPayload(moduleId, functionName, args);
    }

    public static TransactionPayload encode_u8_and_u64_script_function(String moduleId, String functionName, Byte u8, Long u64) {
        List<Bytes> args = Arrays.asList(ExtHelpers.encode_u8_argument(u8), ExtHelpers.encode_u64_argument(u64));
        return ExtHelpers.buildScriptFunctionTransactionPayload(moduleId, functionName, args);
    }

    public static TransactionPayload encode_u8vector_and_u64_script_function(String moduleId, String functionName, Bytes bytes, Long u64) {
        return ExtHelpers.buildScriptFunctionTransactionPayload(moduleId, functionName, Arrays.asList(ExtHelpers.encode_u8vector_argument(bytes), ExtHelpers.encode_u64_argument(u64)));
    }

    @NotNull
    private static TransactionPayload buildScriptFunctionTransactionPayload(String moduleId, String functionName, List<Bytes> args) {
        ScriptFunction.Builder script_function_builder = new ScriptFunction.Builder();
        script_function_builder.ty_args = Collections.emptyList();
        script_function_builder.args = args;
        script_function_builder.function = new Identifier(functionName);
        script_function_builder.module = ExtHelpers.parseModuleId(moduleId);
        TransactionPayload.ScriptFunction.Builder builder = new TransactionPayload.ScriptFunction.Builder();
        builder.value = script_function_builder.build();
        return builder.build();
    }

    private static ModuleId parseModuleId(String m) {
        String[] ss = m.split("::");
        if (ss.length < 2) {
            throw new IllegalArgumentException("Illegal module id.: " + m);
        }
        return new ModuleId(AccountAddressUtils.create(ss[0]), new Identifier(ss[1]));
    }

    private static Bytes encode_bool_argument(Boolean arg) {
        try {
            BcsSerializer s = new BcsSerializer();
            s.serialize_bool(arg);
            return Bytes.valueOf(s.get_bytes());
        }
        catch (SerializationError e) {
            throw new IllegalArgumentException("Unable to serialize argument of type bool");
        }
    }

    private static Bytes encode_u64_argument(@Unsigned Long arg) {
        try {
            BcsSerializer s = new BcsSerializer();
            s.serialize_u64(arg);
            return Bytes.valueOf(s.get_bytes());
        }
        catch (SerializationError e) {
            throw new IllegalArgumentException("Unable to serialize argument of type u64");
        }
    }

    private static Bytes encode_u8_argument(@Unsigned Byte arg) {
        try {
            BcsSerializer s = new BcsSerializer();
            s.serialize_u8(arg);
            return Bytes.valueOf(s.get_bytes());
        }
        catch (SerializationError e) {
            throw new IllegalArgumentException("Unable to serialize argument of type u8");
        }
    }

    private static Bytes encode_u128_argument(@Unsigned @Int128 BigInteger arg) {
        try {
            BcsSerializer s = new BcsSerializer();
            s.serialize_u128(arg);
            return Bytes.valueOf(s.get_bytes());
        }
        catch (SerializationError e) {
            throw new IllegalArgumentException("Unable to serialize argument of type u128");
        }
    }

    private static Bytes encode_address_argument(AccountAddress arg) {
        try {
            return Bytes.valueOf(arg.bcsSerialize());
        }
        catch (SerializationError e) {
            throw new IllegalArgumentException("Unable to serialize argument of type address");
        }
    }

    private static Bytes encode_u8vector_argument(Bytes arg) {
        try {
            BcsSerializer s = new BcsSerializer();
            s.serialize_bytes(arg);
            return Bytes.valueOf(s.get_bytes());
        }
        catch (SerializationError e) {
            throw new IllegalArgumentException("Unable to serialize argument of type u8vector");
        }
    }
}

