/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.utils;

import com.novi.bcs.BcsSerializer;
import com.novi.serde.Bytes;
import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;
import org.starcoin.types.AccountAddress;

public class BcsSerializeHelper {
    public static Bytes serializeU128ToBytes(BigInteger v) {
        BcsSerializer s = new BcsSerializer();
        s.serialize_u128(v);
        return Bytes.valueOf(s.get_bytes());
    }

    public static Bytes serializeAddressToBytes(AccountAddress address) {
        return Bytes.valueOf(address.bcsSerialize());
    }

    public static Bytes serializeU64ToBytes(Long v) {
        BcsSerializer s = new BcsSerializer();
        s.serialize_u64(v);
        return Bytes.valueOf(s.get_bytes());
    }

    public static Bytes serializeVectorU8ToBytes(String str) {
        BcsSerializer s = new BcsSerializer();
        s.serialize_str(str);
        return Bytes.valueOf(s.get_bytes());
    }

    public static Bytes serializeListToBytes(List<String> list) {
        List bytesList = list.stream().map(s -> BcsSerializeHelper.serializeVectorU8ToBytes(s)).collect(Collectors.toList());
        BcsSerializer s2 = new BcsSerializer();
        s2.serialize_len(bytesList.size());
        for (Bytes item : bytesList) {
            s2.serialize_bytes(item);
        }
        byte[] bytes = s2.get_bytes();
        return Bytes.valueOf(bytes);
    }

    public static byte[] serializeU64(Long v) {
        long value = v;
        BcsSerializer serializer = new BcsSerializer();
        serializer.increase_container_depth();
        serializer.serialize_u64(value);
        serializer.decrease_container_depth();
        return serializer.get_bytes();
    }

    public static byte[] serializeU128(BigInteger v) {
        BcsSerializer serializer = new BcsSerializer();
        serializer.increase_container_depth();
        serializer.serialize_u128(v);
        serializer.decrease_container_depth();
        return serializer.get_bytes();
    }

    public static byte[] serializeString(String v) {
        BcsSerializer serializer = new BcsSerializer();
        serializer.increase_container_depth();
        serializer.serialize_str(v);
        serializer.decrease_container_depth();
        return serializer.get_bytes();
    }

    public static byte[] serializeU8(Byte v) {
        BcsSerializer serializer = new BcsSerializer();
        serializer.increase_container_depth();
        serializer.serialize_u8(v);
        serializer.decrease_container_depth();
        return serializer.get_bytes();
    }

    public static byte[] serializeVectorU8(List<Byte> value) {
        BcsSerializer serializer = new BcsSerializer();
        serializer.serialize_len(value.size());
        for (Byte item : value) {
            serializer.serialize_u8(item);
        }
        return serializer.get_bytes();
    }
}

