/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.starcoin.jsonrpc.JSONRPC2Request;
import org.starcoin.jsonrpc.JSONRPC2Response;
import org.starcoin.jsonrpc.client.JSONRPC2Session;
import org.starcoin.jsonrpc.client.JSONRPC2SessionException;

class JsonRPCClient<T> {
    private static final Logger logger = LoggerFactory.getLogger(JsonRPCClient.class);

    JsonRPCClient() {
    }

    protected T getObject(JSONRPC2Session session, String method, List<Object> params, int requestId, Class<T> clazz) throws JSONRPC2SessionException {
        JSONRPC2Request request = new JSONRPC2Request(method, params, (Object)requestId);
        JSONRPC2Response response = session.send(request);
        if (response.indicatesSuccess()) {
            Object result = response.getResult();
            if (result != null) {
                return (T)new ObjectMapper().convertValue(result, clazz);
            }
            logger.warn("get object result is null, method:" + method);
        } else {
            logger.error("getObject error, url:{}, request:{}, class: {}, error: {}", new Object[]{session.getURL(), request, clazz, response.getError()});
        }
        return null;
    }

    protected T getObjectParseJackson(JSONRPC2Session session, String method, List<Object> params, int requestId, Class<T> clazz) throws JSONRPC2SessionException, IOException {
        JSONRPC2Request request = new JSONRPC2Request(method, params, (Object)requestId);
        JSONRPC2Response response = session.send(request);
        if (response.indicatesSuccess()) {
            Object result = response.getResult();
            if (result != null) {
                ObjectMapper objectMapper = new ObjectMapper();
                return (T)objectMapper.convertValue(result, clazz);
            }
            logger.warn("get object parse jackson result is null, method:" + method);
        } else {
            logger.error("getObjectParseJackson failed, url:{}, request:{}, class: {}, error: {}", new Object[]{session.getURL(), request, clazz, response.getError()});
        }
        return null;
    }

    protected T getSubObject(JSONRPC2Session session, String method, List<Object> params, int requestId, String subKey, Class<T> clazz) throws JSONRPC2SessionException, JsonProcessingException {
        JSONRPC2Request request = new JSONRPC2Request(method, params, (Object)requestId);
        JSONRPC2Response response = session.send(request);
        if (response.indicatesSuccess()) {
            Object result = response.getResult();
            if (result != null) {
                Map map = (Map)new ObjectMapper().convertValue(result, Map.class);
                return (T)(map.get(subKey) == null ? null : new ObjectMapper().convertValue(map.get(subKey), clazz));
            }
            logger.warn("get sub object result is null, method:" + method);
        } else {
            logger.error("getSubObject error, url:{}, request:{}, class: {}, error: {}", new Object[]{session.getURL(), request, clazz, response.getError()});
        }
        return null;
    }

    protected List<T> getObjectArray(JSONRPC2Session session, String method, List<Object> params, int requestId, Class<T> clazz) throws JSONRPC2SessionException {
        JSONRPC2Request request = new JSONRPC2Request(method, params, (Object)requestId);
        JSONRPC2Response response = session.send(request);
        if (response.indicatesSuccess()) {
            Object result = response.getResult();
            if (result != null) {
                ObjectMapper objectMapper = new ObjectMapper();
                List list = (List)objectMapper.convertValue(result, (TypeReference)new TypeReference<List<Object>>(){});
                return list.stream().map(item -> objectMapper.convertValue(item, clazz)).collect(Collectors.toList());
            }
            logger.warn("get object result is null, method:" + method);
        } else {
            logger.error("getObjectArray error, url:{}, request:{}, class: {}, error: {}", new Object[]{session.getURL(), request, clazz, response.getError()});
        }
        return null;
    }
}

