/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.jsonrpc;

import java.util.List;
import java.util.Map;
import org.starcoin.jsonrpc.JSONRPC2ParamsType;

public class JSONRPC2Request {
    private String method;
    private List<Object> positionalParams;
    private Map<String, Object> namedParams;
    private Object id;

    public JSONRPC2Request(String method, Object id) {
        this.setMethod(method);
        this.setID(id);
    }

    public JSONRPC2Request(String method, List<Object> positionalParams, Object id) {
        this.setMethod(method);
        this.setPositionalParams(positionalParams);
        this.setID(id);
    }

    public JSONRPC2Request(String method, Map<String, Object> namedParams, Object id) {
        this.setMethod(method);
        this.setNamedParams(namedParams);
        this.setID(id);
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        if (method == null) {
            throw new IllegalArgumentException("The method name must not be null");
        }
        this.method = method;
    }

    public JSONRPC2ParamsType getParamsType() {
        if (this.positionalParams == null && this.namedParams == null) {
            return JSONRPC2ParamsType.NO_PARAMS;
        }
        if (this.positionalParams != null) {
            return JSONRPC2ParamsType.ARRAY;
        }
        if (this.namedParams != null) {
            return JSONRPC2ParamsType.OBJECT;
        }
        return JSONRPC2ParamsType.NO_PARAMS;
    }

    public Object getParams() {
        switch (this.getParamsType()) {
            case ARRAY: {
                return this.positionalParams;
            }
            case OBJECT: {
                return this.namedParams;
            }
        }
        return null;
    }

    @Deprecated
    public void setParams(Object params) {
        if (params == null) {
            this.positionalParams = null;
            this.namedParams = null;
        } else if (params instanceof List) {
            this.positionalParams = (List)params;
        } else if (params instanceof Map) {
            this.namedParams = (Map)params;
        } else {
            throw new IllegalArgumentException("The request parameters must be of type List, Map or null");
        }
    }

    public List<Object> getPositionalParams() {
        return this.positionalParams;
    }

    public void setPositionalParams(List<Object> positionalParams) {
        if (positionalParams == null) {
            return;
        }
        this.positionalParams = positionalParams;
    }

    public Map<String, Object> getNamedParams() {
        return this.namedParams;
    }

    public void setNamedParams(Map<String, Object> namedParams) {
        if (namedParams == null) {
            return;
        }
        this.namedParams = namedParams;
    }

    public Object getID() {
        return this.id;
    }

    public void setID(Object id) {
        this.id = id == null || id instanceof Boolean || id instanceof Number || id instanceof String ? id : id.toString();
    }

    public String toString() {
        return "JSONRPC2Request{method='" + this.method + '\'' + ", params=" + this.getParams() + ", id=" + this.id + '}';
    }
}

