/*
 * Decompiled with CFR 0.152.
 */
package org.starcoin.types;

import com.novi.bcs.BcsDeserializer;
import com.novi.bcs.BcsSerializer;
import com.novi.serde.Bytes;
import com.novi.serde.DeserializationError;
import com.novi.serde.Deserializer;
import com.novi.serde.SerializationError;
import com.novi.serde.Serializer;
import java.util.List;
import java.util.Objects;
import org.starcoin.types.ArgumentABI;
import org.starcoin.types.TraitHelpers;
import org.starcoin.types.TypeArgumentABI;

public final class TransactionScriptABI {
    public final String name;
    public final String doc;
    public final Bytes code;
    public final List<TypeArgumentABI> ty_args;
    public final List<ArgumentABI> args;

    public TransactionScriptABI(String name, String doc, Bytes code, List<TypeArgumentABI> ty_args, List<ArgumentABI> args) {
        Objects.requireNonNull(name, "name must not be null");
        Objects.requireNonNull(doc, "doc must not be null");
        Objects.requireNonNull(code, "code must not be null");
        Objects.requireNonNull(ty_args, "ty_args must not be null");
        Objects.requireNonNull(args, "args must not be null");
        this.name = name;
        this.doc = doc;
        this.code = code;
        this.ty_args = ty_args;
        this.args = args;
    }

    public static TransactionScriptABI deserialize(Deserializer deserializer) throws DeserializationError {
        deserializer.increase_container_depth();
        Builder builder = new Builder();
        builder.name = deserializer.deserialize_str();
        builder.doc = deserializer.deserialize_str();
        builder.code = deserializer.deserialize_bytes();
        builder.ty_args = TraitHelpers.deserialize_vector_TypeArgumentABI(deserializer);
        builder.args = TraitHelpers.deserialize_vector_ArgumentABI(deserializer);
        deserializer.decrease_container_depth();
        return builder.build();
    }

    public static TransactionScriptABI bcsDeserialize(byte[] input) throws DeserializationError {
        if (input == null) {
            throw new DeserializationError("Cannot deserialize null array");
        }
        BcsDeserializer deserializer = new BcsDeserializer(input);
        TransactionScriptABI value = TransactionScriptABI.deserialize(deserializer);
        if (deserializer.get_buffer_offset() < input.length) {
            throw new DeserializationError("Some input bytes were not read");
        }
        return value;
    }

    public void serialize(Serializer serializer) throws SerializationError {
        serializer.increase_container_depth();
        serializer.serialize_str(this.name);
        serializer.serialize_str(this.doc);
        serializer.serialize_bytes(this.code);
        TraitHelpers.serialize_vector_TypeArgumentABI(this.ty_args, serializer);
        TraitHelpers.serialize_vector_ArgumentABI(this.args, serializer);
        serializer.decrease_container_depth();
    }

    public byte[] bcsSerialize() throws SerializationError {
        BcsSerializer serializer = new BcsSerializer();
        this.serialize(serializer);
        return serializer.get_bytes();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransactionScriptABI other = (TransactionScriptABI)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.doc, other.doc)) {
            return false;
        }
        if (!Objects.equals(this.code, other.code)) {
            return false;
        }
        if (!Objects.equals(this.ty_args, other.ty_args)) {
            return false;
        }
        return Objects.equals(this.args, other.args);
    }

    public int hashCode() {
        int value = 7;
        value = 31 * value + (this.name != null ? this.name.hashCode() : 0);
        value = 31 * value + (this.doc != null ? this.doc.hashCode() : 0);
        value = 31 * value + (this.code != null ? this.code.hashCode() : 0);
        value = 31 * value + (this.ty_args != null ? this.ty_args.hashCode() : 0);
        value = 31 * value + (this.args != null ? this.args.hashCode() : 0);
        return value;
    }

    public static final class Builder {
        public String name;
        public String doc;
        public Bytes code;
        public List<TypeArgumentABI> ty_args;
        public List<ArgumentABI> args;

        public TransactionScriptABI build() {
            return new TransactionScriptABI(this.name, this.doc, this.code, this.ty_args, this.args);
        }
    }
}

