/*
 * Decompiled with CFR 0.152.
 */
package org.stefaniuk.json.service;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.codehaus.jackson.node.POJONode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stefaniuk.json.service.JsonService;
import org.stefaniuk.json.service.JsonServiceError;
import org.stefaniuk.json.service.JsonServiceException;
import org.stefaniuk.json.service.JsonServiceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonServiceInvoker {
    private final Logger logger = LoggerFactory.getLogger(JsonServiceInvoker.class);
    private static ObjectMapper mapper = new ObjectMapper();
    private boolean isInitialised = false;
    private final Class<?> clazz;
    private Object context;
    private Map<String, Method> methods = new HashMap<String, Method>();
    private Transport transport = Transport.POST;
    private ContentType contentType = ContentType.APPLICATION_JSON;
    private Envelope envelope = Envelope.JSON_RPC_2_0;
    private Version version = Version.SMD_2_0;
    private ObjectNode smd;

    public JsonServiceInvoker(Class<?> clazz) {
        this.clazz = clazz;
    }

    public JsonServiceInvoker(Object obj) {
        this.clazz = obj.getClass();
        this.context = obj;
    }

    public JsonServiceInvoker setTransport(Transport transport) {
        this.transport = transport;
        return this;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public JsonServiceInvoker setContentType(ContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public JsonServiceInvoker setEnvelope(Envelope envelope) {
        this.envelope = envelope;
        return this;
    }

    public Envelope getEnvelope() {
        return this.envelope;
    }

    public JsonServiceInvoker setVersion(Version version) {
        this.version = version;
        return this;
    }

    public Version getVersion() {
        return this.version;
    }

    private void init() {
        try {
            if (this.context == null) {
                Constructor<?> ctor = this.clazz.getConstructor(new Class[0]);
                this.context = ctor.newInstance(new Object[0]);
            }
            for (Method method : this.clazz.getMethods()) {
                if (!this.isService(this.clazz, method)) continue;
                this.methods.put(method.getName(), method);
            }
            this.smd = mapper.createObjectNode();
            this.smd.put("transport", this.transport.toString());
            this.smd.put("contentType", this.contentType.toString());
            this.smd.put("envelope", this.envelope.toString());
            this.smd.put("SMDVersion", this.version.toString());
            this.smd.put("additionalParameters", false);
            ObjectNode services = mapper.createObjectNode();
            for (Method method : this.methods.values()) {
                String description;
                String target;
                Envelope envelope;
                ContentType contentType;
                Transport transport;
                ObjectNode temp = mapper.createObjectNode();
                JsonService annotation = method.getAnnotation(JsonService.class);
                if (annotation == null) {
                    annotation = this.clazz.getAnnotation(JsonService.class);
                }
                if ((transport = annotation.transport()) != Transport.UNDEFINED && transport != this.transport) {
                    temp.put("transport", transport.toString());
                }
                if ((contentType = annotation.contentType()) != ContentType.UNDEFINED && contentType != this.contentType) {
                    temp.put("contentType", contentType.toString());
                }
                if ((envelope = annotation.envelope()) != Envelope.UNDEFINED && envelope != this.envelope) {
                    temp.put("envelope", envelope.toString());
                }
                if (!(target = annotation.target()).equals("")) {
                    temp.put("target", target);
                }
                if (!(description = annotation.description()).equals("")) {
                    temp.put("description", description);
                }
                ArrayNode parameters = mapper.createArrayNode();
                for (Class<?> type : method.getParameterTypes()) {
                    ObjectNode node = mapper.createObjectNode();
                    node.put("type", DataType.getName(type));
                    parameters.add((JsonNode)node);
                }
                temp.put("parameters", (JsonNode)parameters);
                Class<?> returnType = method.getReturnType();
                if (!"void".equals(returnType.toString())) {
                    ObjectNode node = mapper.createObjectNode();
                    node.put("type", DataType.getName(returnType));
                    temp.put("returns", (JsonNode)node);
                }
                services.put(method.getName(), (JsonNode)temp);
            }
            this.smd.put("services", (JsonNode)services);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private boolean isService(Class<?> clazz, Method method) {
        boolean hasAnnotation = clazz.getAnnotation(JsonService.class) != null || method.getAnnotation(JsonService.class) != null;
        return hasAnnotation && Modifier.isPublic(method.getModifiers());
    }

    protected JsonNode getServiceMap() {
        if (!this.isInitialised) {
            this.init();
            this.logger.debug("JSON-RPC SMD: " + this.smd.toString());
        }
        return this.smd;
    }

    protected JsonNode process(HttpServletRequest request, ObjectNode requestNode) throws IllegalAccessException, InvocationTargetException, JsonParseException, JsonMappingException, IOException {
        this.logger.debug("JSON-RPC request: " + requestNode.toString());
        if (!this.isInitialised) {
            this.init();
        }
        JsonNode response = null;
        try {
            if (!requestNode.has("method") || "".equals(requestNode.get("method"))) {
                throw new JsonServiceException(JsonServiceError.INVALID_REQUEST);
            }
            String name = requestNode.get("method").getTextValue();
            Method method = this.methods.get(name);
            if (method == null) {
                throw new JsonServiceException(JsonServiceError.METHOD_NOT_FOUND);
            }
            this.logger.debug("JSON-RPC method call: " + method.getDeclaringClass().getName() + "." + method.getName());
            ArrayNode params = (ArrayNode)ArrayNode.class.cast(requestNode.get("params"));
            ArrayList<Object> temp = new ArrayList<Object>();
            Type[] types = method.getGenericParameterTypes();
            int i = 0;
            int count = 1;
            for (Type type : types) {
                if (type.equals(HttpServletRequest.class)) {
                    this.logger.debug("JSON-RPC argument type " + count + ": " + request.getClass().getCanonicalName());
                    temp.add(request);
                } else {
                    JsonNode node;
                    Object obj;
                    if ((obj = mapper.treeToValue(node = params.get(i++), TypeFactory.rawClass((Type)type))) instanceof List) {
                        List list = (List)obj;
                        for (int j = 0; j < list.size(); ++j) {
                            try {
                                String className = ((ParameterizedType)type).getActualTypeArguments()[0].toString().replace("class ", "");
                                Object pojo = mapper.readValue((JsonNode)JsonServiceUtil.toJson((Map)list.get(j)), Class.forName(className));
                                list.set(j, pojo);
                                continue;
                            }
                            catch (ClassNotFoundException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    temp.add(obj);
                    this.logger.debug("JSON-RPC argument " + count + " type: " + obj.getClass().getCanonicalName());
                    this.logger.debug("JSON-RPC argument " + count + " value: " + obj.toString());
                }
                ++count;
            }
            Object[] args = new Object[temp.size()];
            temp.toArray(args);
            try {
                response = this.getJsonRpcSuccessResponse(requestNode.get("id").getIntValue(), method.invoke(this.context, args));
            }
            catch (IllegalArgumentException e) {
                throw new JsonServiceException(JsonServiceError.INVALID_PARAMS);
            }
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof JsonServiceException) {
                JsonServiceException jse = (JsonServiceException)t;
                response = this.getJsonRpcErrorResponse(requestNode.get("id").getIntValue(), jse.getError());
            }
            throw e;
        }
        catch (JsonServiceException e) {
            response = this.getJsonRpcErrorResponse(requestNode.get("id").getIntValue(), e.getError());
        }
        this.logger.debug("JSON-RPC response: " + response.toString());
        return response;
    }

    protected JsonNode process(HttpServletRequest request, String method, Object ... args) throws IllegalAccessException, InvocationTargetException, JsonParseException, JsonMappingException, IOException {
        if (!this.isInitialised) {
            this.init();
        }
        JsonNode response = null;
        try {
            Method m = this.methods.get(method);
            if (m == null) {
                throw new JsonServiceException(JsonServiceError.METHOD_NOT_FOUND);
            }
            this.logger.debug("JSON-RPC call method: " + m.getDeclaringClass().getName() + "." + m.getName());
            ArrayList<Object> temp = new ArrayList<Object>();
            Type[] types = m.getGenericParameterTypes();
            int i = 0;
            int count = 1;
            for (Type type : types) {
                if (type.equals(HttpServletRequest.class)) {
                    this.logger.debug("JSON-RPC argument " + count + ": " + request.getClass().getCanonicalName());
                    temp.add(request);
                } else {
                    this.logger.debug("JSON-RPC argument " + count + ": " + args[i++].getClass().getCanonicalName());
                    temp.add(args[i++]);
                }
                ++count;
            }
            Object[] arguments = new Object[temp.size()];
            temp.toArray(arguments);
            try {
                response = this.getJsonSuccessResponse(m.invoke(this.context, arguments));
            }
            catch (IllegalArgumentException e) {
                throw new JsonServiceException(JsonServiceError.INVALID_PARAMS);
            }
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof JsonServiceException) {
                JsonServiceException jse = (JsonServiceException)t;
                response = this.getJsonErrorResponse(jse.getError());
            }
            throw e;
        }
        catch (JsonServiceException e) {
            response = this.getJsonErrorResponse(e.getError());
        }
        this.logger.debug("JSON-RPC response: " + response.toString());
        return response;
    }

    private JsonNode getJsonSuccessResponse(Object result) {
        if (result instanceof Map) {
            return JsonServiceUtil.toJson((Map)result);
        }
        return new POJONode(result);
    }

    private JsonNode getJsonErrorResponse(JsonServiceError error) {
        ObjectNode errorNode = mapper.createObjectNode();
        errorNode.put("code", error.getCode());
        errorNode.put("message", error.getMessage());
        ObjectNode responseNode = mapper.createObjectNode();
        responseNode.put("error", (JsonNode)errorNode);
        return responseNode;
    }

    private JsonNode getJsonRpcSuccessResponse(Integer id, Object result) {
        ObjectNode responseNode = mapper.createObjectNode();
        if (id != null) {
            responseNode.put("id", id);
        } else {
            responseNode.putNull("id");
        }
        if (result instanceof List) {
            responseNode.put("result", (JsonNode)JsonServiceUtil.toJson((List)result));
        } else if (result instanceof Map) {
            responseNode.put("result", (JsonNode)JsonServiceUtil.toJson((Map)result));
        } else {
            try {
                responseNode.put("result", (JsonNode)new POJONode(result));
            }
            catch (Exception e) {
                responseNode.put("result", result != null ? result.toString() : null);
            }
        }
        responseNode.putNull("error");
        responseNode.put("jsonrpc", this.envelope.toString());
        return responseNode;
    }

    private JsonNode getJsonRpcErrorResponse(Integer id, JsonServiceError error) {
        ObjectNode errorNode = mapper.createObjectNode();
        errorNode.put("code", error.getCode());
        errorNode.put("message", error.getMessage());
        ObjectNode responseNode = mapper.createObjectNode();
        if (id != null) {
            responseNode.put("id", id);
        } else {
            responseNode.putNull("id");
        }
        responseNode.putNull("result");
        responseNode.put("error", (JsonNode)errorNode);
        responseNode.put("jsonrpc", this.envelope.toString());
        return responseNode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataType {
        ARRAY(new Class[]{ArrayList.class}),
        OBJECT(new Class[]{LinkedHashMap.class}),
        NUMBER(new Class[]{Float.class, Double.class}),
        INTEGER(new Class[]{Integer.class, Long.class}),
        BOOLEAN(new Class[]{Boolean.class}),
        STRING(new Class[]{String.class});

        private final Class<?>[] classes;

        private DataType(Class<?>[] classes) {
            this.classes = classes;
        }

        public static String getName(Class<?> clazz) {
            for (DataType type : DataType.values()) {
                for (Class<?> c : type.classes) {
                    if (!clazz.equals(c)) continue;
                    return type.toString();
                }
            }
            return OBJECT.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Version {
        UNDEFINED(""),
        SMD_2_0("2.0");

        private final String name;

        private Version(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Envelope {
        UNDEFINED(""),
        JSON_RPC_2_0("JSON-RPC-2.0");

        private final String name;

        private Envelope(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentType {
        UNDEFINED(""),
        APPLICATION_JSON("application/json");

        private final String name;

        private ContentType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Transport {
        UNDEFINED(""),
        POST("POST");

        private final String name;

        private Transport(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

