/*
 * Decompiled with CFR 0.152.
 */
package org.stefaniuk.json.service;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stefaniuk.json.service.JsonServiceError;
import org.stefaniuk.json.service.JsonServiceException;
import org.stefaniuk.json.service.JsonServiceInvoker;
import org.stefaniuk.json.service.JsonServiceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonServiceRegistry {
    private final Logger logger = LoggerFactory.getLogger(JsonServiceRegistry.class);
    private static JsonServiceRegistry INSTANCE = null;
    private static ObjectMapper mapper = new ObjectMapper();
    private Map<String, JsonServiceInvoker> registry = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JsonServiceRegistry getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<JsonServiceRegistry> clazz = JsonServiceRegistry.class;
        synchronized (JsonServiceRegistry.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new JsonServiceRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public boolean isSingleton() {
        return this == INSTANCE;
    }

    public JsonServiceRegistry register(Class<?> clazz) {
        String name = clazz.getName();
        if (!this.registry.containsKey(name)) {
            this.registry.put(name, new JsonServiceInvoker(clazz));
            this.logger.info("JSON-RPC registered class: " + name);
        }
        return this;
    }

    public JsonServiceRegistry register(Object obj) {
        String name = obj.getClass().getName();
        if (!this.registry.containsKey(name)) {
            this.registry.put(name, new JsonServiceInvoker(obj));
            this.logger.info("JSON-RPC registered class: " + name);
        }
        return this;
    }

    public JsonServiceRegistry setRegistry(Class<?>[] classes) {
        this.registry.clear();
        for (Class<?> clazz : classes) {
            this.register(clazz);
        }
        return this;
    }

    public JsonServiceRegistry unregister(Class<?> clazz) {
        String name = clazz.getName();
        if (this.registry.containsKey(name)) {
            this.registry.remove(name);
            this.logger.info("JSON-RPC unregistered class: " + name);
        }
        return this;
    }

    public JsonServiceRegistry unregister(Object obj) {
        String name = obj.getClass().getName();
        if (this.registry.containsKey(name)) {
            this.registry.remove(name);
            this.logger.info("JSON-RPC unregistered class: " + name);
        }
        return this;
    }

    public JsonServiceRegistry clearRegistry() {
        this.registry.clear();
        this.logger.info("JSON-RPC unregistered all classes");
        return this;
    }

    private JsonServiceInvoker lookup(Class<?> clazz) {
        return this.registry.get(clazz.getName());
    }

    public OutputStream getServiceMap(Class<?> clazz, OutputStream os) {
        try {
            mapper.writeValue(os, (Object)this.lookup(clazz).getServiceMap());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return os;
    }

    public OutputStream getServiceMap(Class<?> clazz, HttpServletResponse response) {
        OutputStream os = null;
        try {
            os = this.getServiceMap(clazz, (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        return os;
    }

    public OutputStream handle(InputStream is, OutputStream os, Class<?> clazz) {
        try {
            this.handleNode(null, (JsonNode)mapper.readValue(is, JsonNode.class), os, this.lookup(clazz));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            try {
                ObjectNode response = JsonServiceUtil.getJsonServiceErrorNode(JsonServiceError.INVALID_REQUEST);
                this.logger.debug("JSON-RPC response: " + response.toString());
                mapper.createObjectNode();
                mapper.writeValue(os, (Object)response);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
        return os;
    }

    public OutputStream handle(InputStream is, OutputStream os, Class<?> clazz, String method, Object ... args) {
        try {
            this.handleNode(null, os, this.lookup(clazz), method, args);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            try {
                ObjectNode response = JsonServiceUtil.getJsonServiceErrorNode(JsonServiceError.INVALID_REQUEST);
                this.logger.debug("JSON-RPC response: " + response.toString());
                mapper.createObjectNode();
                mapper.writeValue(os, (Object)response);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
        return os;
    }

    public OutputStream handle(HttpServletRequest request, HttpServletResponse response, Class<?> clazz) {
        BufferedOutputStream bos = null;
        try {
            this.register(clazz);
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            String method = request.getMethod();
            if (method.equals("GET")) {
                this.getServiceMap(clazz, bos);
            } else {
                this.handle(request, (OutputStream)bos, clazz);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return bos;
    }

    public OutputStream handle(HttpServletRequest request, HttpServletResponse response, Object obj) {
        BufferedOutputStream bos = null;
        try {
            this.register(obj);
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            Class<?> clazz = obj.getClass();
            String method = request.getMethod();
            if (method.equals("GET")) {
                this.getServiceMap(clazz, bos);
            } else {
                this.handle(request, (OutputStream)bos, clazz);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return bos;
    }

    public OutputStream handle(HttpServletRequest request, OutputStream os, Class<?> clazz) {
        try {
            this.handleNode(request, (JsonNode)mapper.readValue((InputStream)request.getInputStream(), JsonNode.class), os, this.lookup(clazz));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            try {
                ObjectNode response = JsonServiceUtil.getJsonServiceErrorNode(JsonServiceError.INVALID_REQUEST);
                this.logger.debug("JSON-RPC response: " + response.toString());
                mapper.createObjectNode();
                mapper.writeValue(os, (Object)response);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
        return os;
    }

    public OutputStream handle(HttpServletRequest request, OutputStream os, Class<?> clazz, String method, Object ... args) {
        try {
            this.handleNode(request, os, this.lookup(clazz), method, args);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            try {
                ObjectNode response = JsonServiceUtil.getJsonServiceErrorNode(JsonServiceError.INVALID_REQUEST);
                this.logger.debug("JSON-RPC response: " + response.toString());
                mapper.createObjectNode();
                mapper.writeValue(os, (Object)response);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
        return os;
    }

    private void handleNode(HttpServletRequest request, OutputStream os, JsonServiceInvoker invoker, String method, Object ... args) throws JsonGenerationException, JsonMappingException, IOException, IllegalAccessException, InvocationTargetException, JsonServiceException {
        this.handleObject(request, os, invoker, method, args);
    }

    private void handleNode(HttpServletRequest request, JsonNode requestNode, OutputStream os, JsonServiceInvoker invoker) throws JsonGenerationException, JsonMappingException, IOException, IllegalAccessException, InvocationTargetException, JsonServiceException {
        if (requestNode.isObject()) {
            this.handleObject(request, (ObjectNode)ObjectNode.class.cast(requestNode), os, invoker);
        } else if (requestNode.isArray()) {
            this.handleArray(request, (ArrayNode)ArrayNode.class.cast(requestNode), os, invoker);
        } else {
            throw new JsonServiceException(JsonServiceError.INVALID_REQUEST);
        }
    }

    private void handleArray(HttpServletRequest request, ArrayNode requestNode, OutputStream os, JsonServiceInvoker invoker) throws JsonGenerationException, JsonMappingException, IOException, IllegalAccessException, InvocationTargetException, JsonServiceException {
        for (int i = 0; i < requestNode.size(); ++i) {
            this.handleNode(request, requestNode.get(i), os, invoker);
        }
    }

    private void handleObject(HttpServletRequest request, OutputStream os, JsonServiceInvoker invoker, String method, Object ... args) throws IllegalAccessException, InvocationTargetException, JsonGenerationException, JsonMappingException, IOException {
        JsonNode responseNode = invoker.process(request, method, args);
        mapper.writeValue(os, (Object)responseNode);
    }

    private void handleObject(HttpServletRequest request, ObjectNode requestNode, OutputStream os, JsonServiceInvoker invoker) throws IllegalAccessException, InvocationTargetException, JsonGenerationException, JsonMappingException, IOException {
        JsonNode responseNode = invoker.process(request, requestNode);
        mapper.writeValue(os, (Object)responseNode);
    }
}

