/*
 * Decompiled with CFR 0.152.
 */
package org.stefaniuk.json.service;

import java.io.BufferedOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.stefaniuk.json.service.JsonServiceError;
import org.stefaniuk.json.service.JsonServiceRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonServiceUtil {
    private static ObjectMapper mapper = new ObjectMapper();
    private static JsonFactory jsonFactory = new JsonFactory();

    public static void setHeadersForServiceMap(BufferedOutputStream bos, HttpServletResponse response) {
        response.setHeader("Content-Type", "application/json; charset=utf-8");
        response.setHeader("Content-Length", Integer.toString(bos.toString().length()));
        response.setStatus(200);
    }

    public static void setHeadersForMethodCall(BufferedOutputStream bos, HttpServletResponse response) {
        String date = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z").format(Calendar.getInstance().getTime());
        response.setHeader("Expires", "Mon, 01 Jan 2000 00:00:00 GMT");
        response.setHeader("Last-Modified", date);
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Content-Type", "application/json; charset=utf-8");
        response.setHeader("Content-Length", Integer.toString(bos.toString().length()));
        response.setStatus(200);
    }

    public static void setHeadersForMethodCall(BufferedOutputStream bos, HttpServletResponse response, int status) {
        String date = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z").format(Calendar.getInstance().getTime());
        response.setHeader("Expires", "Mon, 01 Jan 2000 00:00:00 GMT");
        response.setHeader("Last-Modified", date);
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Content-Type", "application/json; charset=utf-8");
        response.setHeader("Content-Length", Integer.toString(bos.toString().length()));
        response.setStatus(status);
    }

    public static ResponseEntity<String> getResponseEntityForServiceMap(BufferedOutputStream bos) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Content-Type", "application/json; charset=utf-8");
        headers.set("Content-Length", Integer.toString(bos.toString().length()));
        return new ResponseEntity((Object)bos.toString(), (MultiValueMap)headers, HttpStatus.OK);
    }

    public static ResponseEntity<String> getResponseEntityForMethodCall(BufferedOutputStream bos) {
        HttpHeaders headers = new HttpHeaders();
        String date = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z").format(Calendar.getInstance().getTime());
        headers.set("Expires", "Mon, 01 Jan 2000 00:00:00 GMT");
        headers.set("Last-Modified", date);
        headers.set("Cache-Control", "no-cache");
        headers.set("Content-Type", "application/json; charset=utf-8");
        headers.set("Content-Length", Integer.toString(bos.toString().length()));
        return new ResponseEntity((Object)bos.toString(), (MultiValueMap)headers, HttpStatus.OK);
    }

    public static ResponseEntity<String> getResponseEntityForMethodCall(BufferedOutputStream bos, HttpStatus status) {
        HttpHeaders headers = new HttpHeaders();
        String date = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z").format(Calendar.getInstance().getTime());
        headers.set("Expires", "Mon, 01 Jan 2000 00:00:00 GMT");
        headers.set("Last-Modified", date);
        headers.set("Cache-Control", "no-cache");
        headers.set("Content-Type", "application/json; charset=utf-8");
        headers.set("Content-Length", Integer.toString(bos.toString().length()));
        return new ResponseEntity((Object)bos.toString(), (MultiValueMap)headers, status);
    }

    public static ResponseEntity<String> handle(JsonServiceRegistry service, HttpServletRequest request, HttpServletResponse response, Class<?> clazz) throws IOException {
        ResponseEntity<String> re = null;
        BufferedOutputStream bos = (BufferedOutputStream)service.handle(request, response, clazz);
        String method = request.getMethod();
        re = method.equals("GET") ? JsonServiceUtil.getResponseEntityForServiceMap(bos) : JsonServiceUtil.getResponseEntityForMethodCall(bos);
        return re;
    }

    public static ResponseEntity<String> handle(JsonServiceRegistry service, HttpServletRequest request, HttpServletResponse response, Object obj) throws IOException {
        ResponseEntity<String> re = null;
        BufferedOutputStream bos = (BufferedOutputStream)service.handle(request, response, obj);
        String method = request.getMethod();
        re = method.equals("GET") ? JsonServiceUtil.getResponseEntityForServiceMap(bos) : JsonServiceUtil.getResponseEntityForMethodCall(bos);
        return re;
    }

    public static <T> Object fromJson(String jsonAsString, Class<T> pojoClass) throws JsonMappingException, JsonParseException, IOException {
        return mapper.readValue(jsonAsString, pojoClass);
    }

    public static <T> Object fromJson(FileReader fr, Class<T> pojoClass) throws JsonParseException, IOException {
        return mapper.readValue((Reader)fr, pojoClass);
    }

    public static String toJson(Object pojo, boolean prettyPrint) throws JsonMappingException, JsonGenerationException, IOException {
        StringWriter sw = new StringWriter();
        JsonGenerator jg = jsonFactory.createJsonGenerator((Writer)sw);
        if (prettyPrint) {
            jg.useDefaultPrettyPrinter();
        }
        mapper.writeValue(jg, pojo);
        return sw.toString();
    }

    public static void toJson(Object pojo, FileWriter fw, boolean prettyPrint) throws JsonMappingException, JsonGenerationException, IOException {
        JsonGenerator jg = jsonFactory.createJsonGenerator((Writer)fw);
        if (prettyPrint) {
            jg.useDefaultPrettyPrinter();
        }
        mapper.writeValue(jg, pojo);
    }

    public static ArrayNode toJson(List<?> list) {
        ArrayNode node = mapper.createArrayNode();
        for (Object obj : list) {
            if (obj instanceof Number) {
                if (obj instanceof Integer) {
                    node.add((Integer)obj);
                    continue;
                }
                if (obj instanceof Double) {
                    node.add((Double)obj);
                    continue;
                }
                if (obj instanceof BigDecimal) {
                    node.add((BigDecimal)obj);
                    continue;
                }
                if (obj instanceof Float) {
                    node.add((Float)obj);
                    continue;
                }
                if (obj instanceof Long) {
                    node.add((Long)obj);
                    continue;
                }
                if (obj instanceof Short) {
                    node.add((int)((Short)obj).shortValue());
                    continue;
                }
                if (!(obj instanceof Byte)) continue;
                node.add((int)((Byte)obj).byteValue());
                continue;
            }
            if (obj instanceof Boolean) {
                node.add((Boolean)obj);
                continue;
            }
            if (obj instanceof String) {
                node.add((String)obj);
                continue;
            }
            if (obj instanceof List) {
                node.add((JsonNode)JsonServiceUtil.toJson((List)obj));
                continue;
            }
            if (obj instanceof Map) {
                node.add((JsonNode)JsonServiceUtil.toJson((Map)obj));
                continue;
            }
            try {
                node.addPOJO(obj);
            }
            catch (Exception e) {
                node.add(obj != null ? obj.toString() : null);
            }
        }
        return node;
    }

    public static ObjectNode toJson(Map<?, ?> map) {
        ObjectNode node = mapper.createObjectNode();
        for (Object key : map.keySet()) {
            String name = (String)key;
            Object obj = map.get(name);
            if (obj instanceof Number) {
                if (obj instanceof Integer) {
                    node.put(name, (Integer)obj);
                    continue;
                }
                if (obj instanceof Double) {
                    node.put(name, (Double)obj);
                    continue;
                }
                if (obj instanceof BigDecimal) {
                    node.put(name, (BigDecimal)obj);
                    continue;
                }
                if (obj instanceof Float) {
                    node.put(name, (Float)obj);
                    continue;
                }
                if (obj instanceof Long) {
                    node.put(name, (Long)obj);
                    continue;
                }
                if (obj instanceof Short) {
                    node.put(name, (int)((Short)obj).shortValue());
                    continue;
                }
                if (!(obj instanceof Byte)) continue;
                node.put(name, (int)((Byte)obj).byteValue());
                continue;
            }
            if (obj instanceof Boolean) {
                node.put(name, (Boolean)obj);
                continue;
            }
            if (obj instanceof String) {
                node.put(name, (String)obj);
                continue;
            }
            if (obj instanceof List) {
                node.put(name, (JsonNode)JsonServiceUtil.toJson((List)obj));
                continue;
            }
            if (obj instanceof Map) {
                node.put(name, (JsonNode)JsonServiceUtil.toJson((Map)obj));
                continue;
            }
            try {
                node.putPOJO(name, obj);
            }
            catch (Exception e) {
                node.put(name, obj != null ? obj.toString() : null);
            }
        }
        return node;
    }

    protected static ObjectNode getJsonServiceErrorNode(JsonServiceError jse) {
        ObjectNode code = mapper.createObjectNode();
        code.put("code", jse.getCode());
        code.put("message", jse.getMessage());
        ObjectNode node = mapper.createObjectNode();
        node.put("jsonrpc", "2.0");
        node.put("error", (JsonNode)code);
        node.putNull("id");
        return node;
    }

    protected static ObjectNode getJsonServiceErrorNode(JsonServiceError jse, int id) {
        ObjectNode code = mapper.createObjectNode();
        code.put("code", jse.getCode());
        code.put("message", jse.getMessage());
        ObjectNode node = mapper.createObjectNode();
        node.put("jsonrpc", "2.0");
        node.put("error", (JsonNode)code);
        node.put("id", id);
        return node;
    }
}

