/*
 * Decompiled with CFR 0.152.
 */
package org.sterl.loadrunner;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.springframework.http.HttpMethod;

public class LoadTestReporter
implements Closeable {
    final MetricRegistry registry = new MetricRegistry();
    final ConsoleReporter reporter = ConsoleReporter.forRegistry((MetricRegistry)this.registry).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();

    public LoadTestReporter() {
        this.reporter.start(1L, TimeUnit.MINUTES);
    }

    public Timer timer(String url) {
        return this.registry.timer(MetricRegistry.name((String)url, (String[])new String[0]));
    }

    public Counter failedCounter(String url) {
        return this.registry.counter(MetricRegistry.name((String)"failed", (String[])new String[]{url}));
    }

    public Timer timer(HttpMethod method, String url) {
        return this.registry.timer(MetricRegistry.name((String)method.name(), (String[])new String[]{url}));
    }

    public Counter failedCounter(HttpMethod method, String url) {
        return this.registry.counter(MetricRegistry.name((String)"failed", (String[])new String[]{method.name(), url}));
    }

    public void report() {
        this.reporter.report();
    }

    @Override
    public void close() throws IOException {
        this.reporter.close();
    }

    public MetricRegistry getRegistry() {
        return this.registry;
    }
}

