/*
 * Decompiled with CFR 0.152.
 */
package org.sterl.loadrunner;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.concurrent.Callable;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.client.RestTemplate;
import org.sterl.loadrunner.LoadTestReporter;

public abstract class LoadTestRunner<T, V>
implements Callable<T> {
    protected final LoadTestReporter reporter;
    protected final RestTemplate restTemplate;
    protected final String url;
    protected final HttpMethod method;
    private final Counter failedCounter;
    private final Timer timer;

    protected abstract V prepare();

    protected abstract ResponseEntity<T> execute(V var1, RestTemplate var2) throws Exception;

    public LoadTestRunner(LoadTestReporter reporter, RestTemplate restTemplate, String url, HttpMethod method) {
        this(reporter, restTemplate, url, method, reporter.failedCounter(method, url), reporter.timer(method, url));
    }

    @Override
    public T call() throws Exception {
        Object v = this.prepare();
        Timer.Context t = this.timer.time();
        try {
            ResponseEntity result = this.execute(v, this.restTemplate);
            if (result == null) {
                this.failedCounter.inc();
            } else {
                t.close();
                this.reporter.getRegistry().counter(MetricRegistry.name((String)(result.getStatusCodeValue() + ""), (String[])new String[]{this.method.name(), this.url})).inc();
            }
            return (T)(result == null ? null : result.getBody());
        }
        catch (RestClientResponseException e) {
            t.close();
            this.reporter.getRegistry().counter(MetricRegistry.name((String)(e.getRawStatusCode() + ""), (String[])new String[]{this.method.name(), this.url})).inc();
            throw e;
        }
        catch (Exception e) {
            this.failedCounter.inc();
            throw e;
        }
    }

    public LoadTestRunner(LoadTestReporter reporter, RestTemplate restTemplate, String url, HttpMethod method, Counter failedCounter, Timer timer) {
        this.reporter = reporter;
        this.restTemplate = restTemplate;
        this.url = url;
        this.method = method;
        this.failedCounter = failedCounter;
        this.timer = timer;
    }
}

