/*
 * Decompiled with CFR 0.152.
 */
package org.sterl.loadrunner.cmd;

import java.util.Base64;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;
import org.sterl.loadrunner.ApacheHttpBuilder;
import org.sterl.loadrunner.LoadTestReporter;
import org.sterl.loadrunner.cmd.CommandLineLoadTest;

public class CommandLineLoadTest {
    private HttpMethod method = HttpMethod.GET;
    private String url;
    private String basicAuth;
    private String payload;
    private int clients = 100;
    private int requests = 10000;
    private HttpHeaders headers;

    public void run(String[] args) throws Exception {
        if (this.parseOptions(args)) {
            try (LoadTestReporter reporter = new LoadTestReporter();){
                ExecutorService executorService = Executors.newFixedThreadPool(this.clients);
                HttpComponentsClientHttpRequestFactory newSslHttpClient = ApacheHttpBuilder.newSslHttpClient((int)(this.clients + 5));
                RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)newSslHttpClient);
                System.out.println(StringUtils.rightPad((String)("Starting: " + this), (int)80, (char)'='));
                long time = System.currentTimeMillis();
                for (int i = 0; i < this.requests; ++i) {
                    executorService.submit(new Runner(reporter, restTemplate, this.url, this.method, this.headers, this.payload));
                }
                executorService.shutdown();
                executorService.awaitTermination(Math.min(1800, this.requests * 30), TimeUnit.SECONDS);
                time = System.currentTimeMillis() - time;
                System.out.println(StringUtils.rightPad((String)(new Date() + " " + this.url), (int)80, (char)'-'));
                System.out.println("Clients:       " + this.clients);
                System.out.println("Request count: " + this.requests);
                System.out.println("Total time:    " + time + "ms.");
                System.out.println();
                ((CloseableHttpClient)newSslHttpClient.getHttpClient()).close();
            }
        }
    }

    private boolean parseOptions(String[] args) {
        Options options = new Options();
        options.addOption("u", "url", true, "URL to load test");
        options.addOption("m", "method", true, "HTTP method to use (GET/POST/PUT).");
        options.addOption("p", "payload", true, "String payload to send.");
        options.addOption("b", "basic", true, "Use basic authentication user:password - will be encoded.");
        options.addOption(Option.builder((String)"c").longOpt("clients").hasArg().type(Integer.class).desc("Amount of concurrent threads to use (default 100)").build());
        options.addOption(Option.builder((String)"r").longOpt("requests").hasArg().type(Integer.class).desc("Amount of requests to send (default 10.000)").build());
        if (args == null || args.length > 1) {
            DefaultParser parser = new DefaultParser();
            try {
                CommandLine cmd = parser.parse(options, args);
                this.url = cmd.getOptionValue('u');
                this.headers = new HttpHeaders();
                this.headers.add("Accept", "application/json");
                if (cmd.hasOption('b')) {
                    this.basicAuth = cmd.getOptionValue('b');
                    this.headers.add("Authorization", "Basic " + Base64.getEncoder().encodeToString(this.basicAuth.getBytes()));
                }
                if (cmd.hasOption('c')) {
                    this.clients = Integer.valueOf(cmd.getOptionValue('c'));
                }
                if (cmd.hasOption('r')) {
                    this.requests = Integer.valueOf(cmd.getOptionValue('r'));
                }
                if (cmd.hasOption('m')) {
                    this.method = HttpMethod.valueOf((String)cmd.getOptionValue('m').toUpperCase());
                }
                if (cmd.hasOption('p')) {
                    this.payload = cmd.getOptionValue('p');
                }
                return true;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                return false;
            }
        }
        if (args.length == 1 && args[0].startsWith("http")) {
            this.url = args[0];
            return true;
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("LoadRunner", options);
        return false;
    }

    public String toString() {
        return "CommandLineLoadTest(method=" + this.method + ", url=" + this.url + ", basicAuth=" + this.basicAuth + ", payload=" + this.payload + ", clients=" + this.clients + ", requests=" + this.requests + ", headers=" + this.headers + ")";
    }
}

