/*
 * Decompiled with CFR 0.152.
 */
package org.sterl.pmw;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import lombok.Generated;
import lombok.NonNull;
import org.sterl.pmw.WorkflowService;
import org.sterl.pmw.api.WorkflowInfo;
import org.sterl.pmw.component.WorkflowRepository;
import org.sterl.pmw.model.RunningWorkflowId;
import org.sterl.pmw.model.Workflow;

public abstract class AbstractWorkflowService<RegistryType>
implements WorkflowService<RegistryType> {
    @NonNull
    protected final WorkflowRepository workflowRepository;

    @Override
    public RunningWorkflowId execute(String workflowId) {
        return this.execute(this.workflowRepository.getWorkflow(workflowId));
    }

    @Override
    public RunningWorkflowId execute(String workflowId, Serializable state) {
        return this.execute(workflowId, state, Duration.ZERO);
    }

    @Override
    public RunningWorkflowId execute(String workflowId, Serializable state, Duration delay) {
        Workflow<? extends Serializable> w = this.workflowRepository.getWorkflow(workflowId);
        return this.execute(w, state, delay);
    }

    @Override
    public <T extends Serializable> RunningWorkflowId execute(Workflow<T> w) {
        return this.execute(w, w.newContext());
    }

    @Override
    public <T extends Serializable> RunningWorkflowId execute(Workflow<T> w, T c) {
        return this.execute(w, c, Duration.ZERO);
    }

    @Override
    public void clearAllWorkflows() {
        this.workflowRepository.clear();
    }

    @Override
    public int workflowCount() {
        return this.workflowRepository.workflowCount();
    }

    @Override
    public Collection<WorkflowInfo> listWorkflows() {
        return this.workflowRepository.getWorkflows().entrySet().stream().map(e -> new WorkflowInfo((String)e.getKey(), ((Workflow)e.getValue()).getName(), ((Workflow)e.getValue()).getStepCount())).toList();
    }

    @Generated
    public AbstractWorkflowService(@NonNull WorkflowRepository workflowRepository) {
        if (workflowRepository == null) {
            throw new NullPointerException("workflowRepository is marked non-null but is null");
        }
        this.workflowRepository = workflowRepository;
    }
}

