/*
 * Decompiled with CFR 0.152.
 */
package org.sterl.pmw;

import java.io.IOException;
import java.io.OutputStream;
import lombok.Generated;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.core.DiagramDescription;
import org.springframework.stereotype.Service;
import org.sterl.pmw.component.WorkflowRepository;
import org.sterl.pmw.model.Workflow;
import org.sterl.pmw.uml.DrawWorkflowToUml;

@Service
public class WorkflowUmlService {
    private final WorkflowRepository workflowRepository;

    public DiagramDescription printWorkflowAsPlantUmlSvg(String workflowId, OutputStream out) throws IOException {
        return this.printWorkflowAsPlantUmlSvg(this.workflowRepository.getWorkflow(workflowId), out);
    }

    public DiagramDescription printWorkflowAsPlantUmlSvg(Workflow<?> workflow, OutputStream out) throws IOException {
        String workflowUml = new DrawWorkflowToUml(workflow, this.workflowRepository).draw();
        return this.convertAsPlantUmlSvg(workflowUml, out);
    }

    public DiagramDescription convertAsPlantUmlSvg(String diagram, OutputStream out) throws IOException {
        SourceStringReader reader = new SourceStringReader(diagram);
        return reader.outputImage(out, 0, new FileFormatOption(FileFormat.SVG));
    }

    public String printWorkflow(String workflowId) {
        return this.printWorkflow(this.workflowRepository.getWorkflow(workflowId));
    }

    public String printWorkflow(Workflow<?> w) {
        return new DrawWorkflowToUml(w, this.workflowRepository).draw().toString();
    }

    @Generated
    public WorkflowUmlService(WorkflowRepository workflowRepository) {
        this.workflowRepository = workflowRepository;
    }
}

