/*
 * Decompiled with CFR 0.152.
 */
package org.sterl.pmw.component;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.sterl.pmw.model.Workflow;

@Component
public class WorkflowRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowRepository.class);
    private final Map<String, Workflow<? extends Serializable>> workflows = new ConcurrentHashMap<String, Workflow<? extends Serializable>>();

    public void clear() {
        this.workflows.clear();
    }

    public <T extends Serializable> Workflow<? extends Serializable> register(String id, Workflow<T> w) {
        log.debug("Registering workflow={} id={}", w, (Object)id);
        return this.workflows.put(id, w);
    }

    public <T extends Serializable> void registerUnique(String id, Workflow<T> w) {
        Workflow<Serializable> oldWorkflow = this.register(id, w);
        if (oldWorkflow != null) {
            throw new IllegalArgumentException("Workflow with the ID " + id + " already registered.");
        }
    }

    public Optional<Workflow<? extends Serializable>> findWorkflow(String id) {
        Workflow<? extends Serializable> w = this.workflows.get(id);
        return w == null ? Optional.empty() : Optional.of(w);
    }

    public Workflow<? extends Serializable> getWorkflow(String id) {
        Workflow<? extends Serializable> w = this.workflows.get(id);
        if (w == null) {
            throw new IllegalStateException("No workflow with the ID " + id + " found. Registered " + String.valueOf(this.workflows.keySet()));
        }
        return w;
    }

    public Optional<String> getWorkflowId(Workflow<?> workflow) {
        return this.workflows.entrySet().stream().filter(e -> e.getValue() == workflow).map(e -> (String)e.getKey()).findFirst();
    }

    public boolean hasWorkflows() {
        return !this.workflows.isEmpty();
    }

    public int workflowCount() {
        return this.workflows.size();
    }

    @Generated
    public Map<String, Workflow<? extends Serializable>> getWorkflows() {
        return this.workflows;
    }
}

