/*
 * Decompiled with CFR 0.152.
 */
package org.sterl.pmw.exception;

import lombok.Generated;
import org.sterl.pmw.model.Workflow;
import org.sterl.pmw.model.WorkflowStep;

public abstract class WorkflowException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final Workflow<?> workflow;
    private final WorkflowStep<?> failedStep;

    static final String buildDefaultErrorMessage(Workflow<?> workflow, WorkflowStep<?> failedStep, Exception cause) {
        return "Workflow=" + workflow.getName() + " failed in step=" + failedStep.getId() + " message=" + cause.getMessage();
    }

    public WorkflowException(Workflow<?> workflow, WorkflowStep<?> failedStep, Exception cause) {
        super(WorkflowException.buildDefaultErrorMessage(workflow, failedStep, cause), cause);
        this.workflow = workflow;
        this.failedStep = failedStep;
    }

    @Generated
    public Workflow<?> getWorkflow() {
        return this.workflow;
    }

    @Generated
    public WorkflowStep<?> getFailedStep() {
        return this.failedStep;
    }

    public static class WorkflowFailedDoRetryException
    extends WorkflowException {
        private static final long serialVersionUID = 1L;
        private final int tryCount;

        public WorkflowFailedDoRetryException(Workflow<?> workflow, WorkflowStep<?> failedStep, Exception cause, int tryCount) {
            super(workflow, failedStep, cause);
            this.tryCount = tryCount;
        }

        @Generated
        public int getTryCount() {
            return this.tryCount;
        }
    }

    public static class WorkflowFailedNoRetryException
    extends WorkflowException {
        private static final long serialVersionUID = 1L;
        private final int tryCount;

        public WorkflowFailedNoRetryException(Workflow<?> workflow, WorkflowStep<?> failedStep, Exception cause, int tryCount) {
            super(workflow, failedStep, cause);
            this.tryCount = tryCount;
        }

        @Generated
        public int getTryCount() {
            return this.tryCount;
        }
    }
}

