/*
 * Decompiled with CFR 0.152.
 */
package org.sterl.pmw.model;

import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;
import org.sterl.pmw.model.StepHolder;
import org.sterl.pmw.model.WorkflowStep;

public abstract class AbstractStepFactory<F extends AbstractStepFactory<F, C, T>, C extends StepHolder<C, T>, T extends Serializable> {
    protected final C context;
    protected String id;
    protected String description;
    protected String connectorLabel;
    protected boolean transactional = true;

    public abstract WorkflowStep<T> buildStep();

    public C build() {
        if (this.id == null) {
            this.id = this.context.nextStepId();
        }
        this.context.next(this.buildStep());
        return this.context;
    }

    public F id(String value) {
        this.id = value;
        return (F)this;
    }

    public F description(String value) {
        this.description = value;
        return (F)this;
    }

    public F transactional(boolean value) {
        this.transactional = value;
        return (F)this;
    }

    public F connectorLabel(String value) {
        this.connectorLabel = value;
        return (F)this;
    }

    protected AbstractStepFactory(C context) {
        Objects.requireNonNull(context, "Context cannot be null");
        this.context = context;
    }

    @Generated
    public String toString() {
        return "AbstractStepFactory(id=" + this.getId() + ")";
    }

    @Generated
    public C getContext() {
        return this.context;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getConnectorLabel() {
        return this.connectorLabel;
    }

    @Generated
    public boolean isTransactional() {
        return this.transactional;
    }
}

