/*
 * Decompiled with CFR 0.152.
 */
package org.sterl.pmw.model;

import java.io.Serializable;
import java.util.Map;
import java.util.function.Function;
import org.sterl.pmw.model.AbstractStepFactory;
import org.sterl.pmw.model.ChooseStep;
import org.sterl.pmw.model.SequentialStep;
import org.sterl.pmw.model.SequentialStepFactory;
import org.sterl.pmw.model.StepContainer;
import org.sterl.pmw.model.StepHolder;
import org.sterl.pmw.model.TriggerWorkflowStepFactory;
import org.sterl.pmw.model.Workflow;
import org.sterl.pmw.model.WorkflowChooseFunction;
import org.sterl.pmw.model.WorkflowFunction;
import org.sterl.pmw.model.WorkflowStep;

public class ChooseFactory<C extends StepHolder<C, T>, T extends Serializable>
extends AbstractStepFactory<ChooseFactory<C, T>, C, T>
implements StepHolder<ChooseFactory<C, T>, T> {
    private WorkflowChooseFunction<T> chooseFn;
    private StepContainer<T> steps = new StepContainer();

    public ChooseFactory(C context) {
        super(context);
    }

    public ChooseFactory<C, T> chooseFn(WorkflowChooseFunction<T> value) {
        this.chooseFn = value;
        return this;
    }

    public ChooseFactory<C, T> ifSelected(String stepId, WorkflowFunction<T> fn) {
        this.next((WorkflowStep)new SequentialStep<T>(stepId, fn));
        return this;
    }

    public SequentialStepFactory<ChooseFactory<C, T>, T> ifSelected(String id) {
        return (SequentialStepFactory)new SequentialStepFactory(this).id(id);
    }

    public <SubT extends Serializable> TriggerWorkflowStepFactory<ChooseFactory<C, T>, T, SubT> ifTrigger(String id, Workflow<SubT> subWorkflow, Function<T, SubT> fn) {
        return (TriggerWorkflowStepFactory)new TriggerWorkflowStepFactory<ChooseFactory, T, SubT>(this, subWorkflow).function(fn).id(id);
    }

    public <SubT extends Serializable> TriggerWorkflowStepFactory<ChooseFactory<C, T>, T, SubT> ifTrigger(String id, Workflow<SubT> subWorkflow) {
        return (TriggerWorkflowStepFactory)new TriggerWorkflowStepFactory(this, subWorkflow).id(id);
    }

    public SequentialStepFactory<ChooseFactory<C, T>, T> ifSelected() {
        return new SequentialStepFactory(this);
    }

    @Override
    public ChooseFactory<C, T> next(WorkflowStep<T> s) {
        this.steps.next(s);
        return this;
    }

    @Override
    public Map<String, WorkflowStep<T>> steps() {
        return this.steps.getSteps();
    }

    @Override
    public String nextStepId() {
        return this.context.nextStepId();
    }

    @Override
    public WorkflowStep<T> buildStep() {
        if (this.description == null) {
            this.description = "Choose from " + this.steps.getSteps().size();
        }
        return new ChooseStep<T>(this.id, this.description, this.connectorLabel, this.transactional, this.chooseFn, this.steps.getSteps());
    }
}

