/*
 * Decompiled with CFR 0.152.
 */
package org.sterl.pmw.model;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.sterl.pmw.model.AbstractStep;
import org.sterl.pmw.model.WorkflowChooseFunction;
import org.sterl.pmw.model.WorkflowContext;
import org.sterl.pmw.model.WorkflowStep;

public class ChooseStep<T extends Serializable>
extends AbstractStep<T> {
    private final WorkflowChooseFunction<T> chooseFn;
    private final Map<String, WorkflowStep<T>> subSteps;

    ChooseStep(String id, String description, String connectorLabel, boolean transactional, WorkflowChooseFunction<T> chooseFn, Map<String, WorkflowStep<T>> subSteps) {
        super(id, description, connectorLabel, transactional);
        this.chooseFn = chooseFn;
        this.subSteps = subSteps;
    }

    @Override
    public void apply(WorkflowContext<T> context) {
        String stepId = this.chooseFn.apply(context.data());
        WorkflowStep<T> selectedStep = this.subSteps.get(stepId);
        if (selectedStep == null) {
            throw new IllegalStateException("No step with ID " + stepId + " exists. Select one of " + String.valueOf(this.subSteps.keySet()));
        }
        selectedStep.apply(context);
    }

    public Map<String, WorkflowStep<T>> getSubSteps() {
        return new LinkedHashMap<String, WorkflowStep<T>>(this.subSteps);
    }

    @Generated
    public WorkflowChooseFunction<T> getChooseFn() {
        return this.chooseFn;
    }
}

