/*
 * Decompiled with CFR 0.152.
 */
package org.sterl.pmw.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import lombok.Generated;
import org.sterl.pmw.model.WorkflowStep;

public class StepContainer<T extends Serializable> {
    private final LinkedHashMap<String, WorkflowStep<T>> steps = new LinkedHashMap();
    private final Set<String> usedIds = new HashSet<String>();

    public StepContainer<T> next(WorkflowStep<T> s) {
        this.useId(s.getId());
        this.steps.put(s.getId(), s);
        return this;
    }

    public StepContainer<T> next(String id, WorkflowStep<T> s) {
        this.useId(id);
        this.steps.put(id, s);
        return this;
    }

    public void useId(String id) {
        if (this.usedIds.contains(id)) {
            throw new IllegalArgumentException("WorkflowStep with ID " + id + " already exists.");
        }
        this.usedIds.add(id);
    }

    @Generated
    public LinkedHashMap<String, WorkflowStep<T>> getSteps() {
        return this.steps;
    }
}

