/*
 * Decompiled with CFR 0.152.
 */
package org.sterl.pmw.model;

import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sterl.pmw.command.TriggerWorkflowCommand;
import org.sterl.pmw.model.AbstractStep;
import org.sterl.pmw.model.Workflow;
import org.sterl.pmw.model.WorkflowContext;

public class TriggerWorkflowStep<T extends Serializable, SubWorkflowState extends Serializable>
extends AbstractStep<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TriggerWorkflowStep.class);
    private final Workflow<SubWorkflowState> subWorkflow;
    private final Function<T, SubWorkflowState> fn;
    private final Duration delay;

    TriggerWorkflowStep(String id, String description, String connectorLabel, Workflow<SubWorkflowState> subWorkflow, Function<T, SubWorkflowState> fn, Duration delay) {
        super(id, description, connectorLabel, true);
        this.fn = fn;
        this.subWorkflow = subWorkflow;
        this.delay = delay;
        Objects.requireNonNull(subWorkflow, "Workflow to trigger required");
    }

    @Override
    public void apply(WorkflowContext<T> context) {
        Serializable toStriggerState = null;
        if (this.fn == null) {
            Class<?> subStateType = this.subWorkflow.newContext().getClass();
            if (subStateType.isInstance(context.data())) {
                toStriggerState = (Serializable)subStateType.cast(context.data());
            }
        } else {
            toStriggerState = (Serializable)this.fn.apply(context.data());
        }
        context.addCommand(new TriggerWorkflowCommand<Serializable>(this.subWorkflow, toStriggerState, this.delay));
    }

    @Generated
    public Workflow<SubWorkflowState> getSubWorkflow() {
        return this.subWorkflow;
    }

    @Generated
    public Duration getDelay() {
        return this.delay;
    }
}

