/*
 * Decompiled with CFR 0.152.
 */
package org.sterl.pmw.model;

import java.io.Serializable;
import java.time.Duration;
import java.util.function.Function;
import org.sterl.pmw.model.AbstractStepFactory;
import org.sterl.pmw.model.StepHolder;
import org.sterl.pmw.model.TriggerWorkflowStep;
import org.sterl.pmw.model.Workflow;
import org.sterl.pmw.model.WorkflowStep;

public class TriggerWorkflowStepFactory<C extends StepHolder<C, T>, T extends Serializable, R extends Serializable>
extends AbstractStepFactory<TriggerWorkflowStepFactory<C, T, R>, C, T> {
    private final Workflow<R> subWorkflow;
    private Function<T, R> fn;
    private Duration delay = Duration.ZERO;

    public TriggerWorkflowStepFactory(C context, Workflow<R> subWorkflow) {
        super(context);
        this.subWorkflow = subWorkflow;
    }

    public TriggerWorkflowStepFactory<C, T, R> function(Function<T, R> value) {
        this.fn = value;
        return this;
    }

    public TriggerWorkflowStepFactory<C, T, R> delay(Duration value) {
        this.delay = value;
        return this;
    }

    @Override
    public WorkflowStep<T> buildStep() {
        if (this.description == null) {
            this.description = "Run **" + this.subWorkflow.getName();
            this.description = this.description + "** after " + String.valueOf(this.delay);
        }
        return new TriggerWorkflowStep<T, R>(this.id, this.description, this.connectorLabel, this.subWorkflow, this.fn, this.delay);
    }
}

