/*
 * Decompiled with CFR 0.152.
 */
package org.sterl.pmw.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.sterl.pmw.model.WorkflowFactory;
import org.sterl.pmw.model.WorkflowStep;
import org.sterl.spring.persistent_tasks.api.RetryStrategy;

public class Workflow<T extends Serializable> {
    private final String name;
    @NonNull
    private RetryStrategy retryStrategy = RetryStrategy.THREE_RETRIES;
    private final Supplier<T> contextBuilder;
    private final List<WorkflowStep<T>> workflowSteps = new ArrayList<WorkflowStep<T>>();

    public static <T extends Serializable> WorkflowFactory<T> builder(String name, Supplier<T> contextBuilder) {
        Workflow<T> workflow = new Workflow<T>(name, contextBuilder);
        return new WorkflowFactory<T>(contextBuilder, workflow);
    }

    public Workflow(String name, Supplier<T> contextBuilder) {
        this.name = name;
        this.contextBuilder = contextBuilder;
    }

    public T newContext() {
        return (T)((Serializable)this.contextBuilder.get());
    }

    public List<WorkflowStep<T>> getSteps() {
        return Collections.unmodifiableList(this.workflowSteps);
    }

    public int getStepCount() {
        return this.workflowSteps.size();
    }

    void setWorkflowSteps(Collection<WorkflowStep<T>> workflowSteps) {
        this.workflowSteps.clear();
        this.workflowSteps.addAll(workflowSteps);
    }

    public String toString() {
        return "Workflow[name=" + this.name + ", workflowSteps=" + this.workflowSteps.size() + "]";
    }

    public WorkflowStep<T> getNextStep(WorkflowStep<T> current) {
        return this.getStepByPosition(this.workflowSteps.indexOf(current) + 1);
    }

    public WorkflowStep<T> getStepByPosition(int pos) {
        if (pos >= this.workflowSteps.size()) {
            return null;
        }
        return this.workflowSteps.get(pos);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @NonNull
    @Generated
    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    @Generated
    public void setRetryStrategy(@NonNull RetryStrategy retryStrategy) {
        if (retryStrategy == null) {
            throw new NullPointerException("retryStrategy is marked non-null but is null");
        }
        this.retryStrategy = retryStrategy;
    }
}

