/*
 * Decompiled with CFR 0.152.
 */
package org.sterl.pmw.model;

import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import org.sterl.pmw.model.ChooseFactory;
import org.sterl.pmw.model.ErrorStepFactory;
import org.sterl.pmw.model.StepContainer;
import org.sterl.pmw.model.StepHolder;
import org.sterl.pmw.model.TriggerWorkflowStep;
import org.sterl.pmw.model.WaitStep;
import org.sterl.pmw.model.Workflow;
import org.sterl.pmw.model.WorkflowChooseFunction;
import org.sterl.pmw.model.WorkflowStep;
import org.sterl.spring.persistent_tasks.api.RetryStrategy;

public class WorkflowFactory<T extends Serializable>
implements StepHolder<WorkflowFactory<T>, T> {
    private final AtomicInteger stepIds = new AtomicInteger(0);
    private final StepContainer<T> steps = new StepContainer();
    private final Workflow<T> workflow;
    private final Supplier<T> contextBuilder;
    private RetryStrategy retryStrategy = RetryStrategy.THREE_RETRIES;

    WorkflowFactory(Supplier<T> contextBuilder, Workflow<T> workflow) {
        this.workflow = workflow;
        this.contextBuilder = contextBuilder;
    }

    public ErrorStepFactory<WorkflowFactory<T>, T> onLastStepError() {
        return new ErrorStepFactory(this);
    }

    public <TS extends Serializable> WorkflowFactory<T> trigger(Workflow<TS> toTrigger, Function<T, TS> fn) {
        return this.next((WorkflowStep)new TriggerWorkflowStep<T, TS>(this.nextStepId(), "Start " + toTrigger.getName(), null, toTrigger, fn, Duration.ZERO));
    }

    public WorkflowFactory<T> sleep(Function<T, Duration> fn) {
        return this.next((WorkflowStep)new WaitStep<T>(this.nextStepId(), "Wait using function", fn, false));
    }

    public WorkflowFactory<T> sleep(String id, Function<T, Duration> fn) {
        return this.next((WorkflowStep)new WaitStep<T>(id, null, fn, false));
    }

    public WorkflowFactory<T> sleep(String id, String description, Function<T, Duration> fn) {
        return this.next((WorkflowStep)new WaitStep<T>(id, description, fn, false));
    }

    public WorkflowFactory<T> sleep(String id, Duration duration) {
        return this.next((WorkflowStep)new WaitStep<Serializable>(id, "Wait for " + String.valueOf(duration), s -> duration, false));
    }

    public WorkflowFactory<T> sleep(Duration duration) {
        return this.next((WorkflowStep)new WaitStep<Serializable>(this.nextStepId(), "Wait for " + String.valueOf(duration), s -> duration, false));
    }

    public WorkflowFactory<T> stepRetryStrategy(RetryStrategy retryStrategy) {
        this.retryStrategy = retryStrategy;
        return this;
    }

    public Workflow<T> build() {
        this.workflow.setRetryStrategy(this.retryStrategy);
        this.workflow.setWorkflowSteps(this.steps.getSteps().values());
        return this.workflow;
    }

    public ChooseFactory<WorkflowFactory<T>, T> choose() {
        return new ChooseFactory(this);
    }

    public ChooseFactory<WorkflowFactory<T>, T> choose(WorkflowChooseFunction<T> chooseFn) {
        return new ChooseFactory<WorkflowFactory, T>(this).chooseFn(chooseFn);
    }

    public ChooseFactory<WorkflowFactory<T>, T> choose(String id, WorkflowChooseFunction<T> chooseFn) {
        return (ChooseFactory)new ChooseFactory<WorkflowFactory, T>(this).chooseFn(chooseFn).id(id);
    }

    @Override
    public String nextStepId() {
        return "" + this.stepIds.addAndGet(10);
    }

    @Override
    public WorkflowFactory<T> next(WorkflowStep<T> s) {
        this.steps.next(s);
        return this;
    }

    public WorkflowFactory<T> useId(String id) {
        this.steps.useId(id);
        return this;
    }

    @Override
    public Map<String, WorkflowStep<T>> steps() {
        return this.steps.getSteps();
    }

    public WorkflowFactory<T> await(Duration timeout) {
        return this.await(this.nextStepId(), timeout);
    }

    public WorkflowFactory<T> await(String id, Duration timeout) {
        return this.next((WorkflowStep)new WaitStep<Serializable>(id, "Suspend at most " + String.valueOf(timeout), s -> timeout, true));
    }
}

