/*
 * Decompiled with CFR 0.152.
 */
package org.sterl.pmw.spring;

import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.data.domain.Pageable;
import org.sterl.pmw.AbstractWorkflowService;
import org.sterl.pmw.command.TriggerWorkflowCommand;
import org.sterl.pmw.component.WorkflowRepository;
import org.sterl.pmw.model.RunningWorkflowId;
import org.sterl.pmw.model.Workflow;
import org.sterl.pmw.model.WorkflowStep;
import org.sterl.pmw.spring.component.WorkflowHelper;
import org.sterl.pmw.spring.component.WorkflowStepComponent;
import org.sterl.spring.persistent_tasks.PersistentTaskService;
import org.sterl.spring.persistent_tasks.api.TaskId;
import org.sterl.spring.persistent_tasks.api.TriggerKey;
import org.sterl.spring.persistent_tasks.api.TriggerRequest;
import org.sterl.spring.persistent_tasks.api.TriggerSearch;
import org.sterl.spring.persistent_tasks.api.TriggerStatus;
import org.sterl.spring.persistent_tasks.shared.model.HasTrigger;
import org.sterl.spring.persistent_tasks.shared.model.TriggerEntity;
import org.sterl.spring.persistent_tasks.task.TaskService;
import org.sterl.spring.persistent_tasks.trigger.TriggerService;

public class PersistentWorkflowService
extends AbstractWorkflowService<TaskId<? extends Serializable>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PersistentWorkflowService.class);
    private final PersistentTaskService persistentTaskService;
    private final TriggerService triggerService;
    private final TaskService taskService;
    private final Map<Workflow<?>, TaskId<?>> firstTaskRef = new ConcurrentHashMap();

    public PersistentWorkflowService(PersistentTaskService persistentTaskService, TriggerService triggerService, TaskService taskService, WorkflowRepository workflowRepository) {
        super(workflowRepository);
        this.triggerService = triggerService;
        this.taskService = taskService;
        this.persistentTaskService = persistentTaskService;
    }

    @Override
    @EventListener(value={TriggerWorkflowCommand.class})
    public <T extends Serializable> RunningWorkflowId execute(TriggerWorkflowCommand<T> workflowCommand) {
        return this.execute(workflowCommand.workflow(), workflowCommand.state(), workflowCommand.delay());
    }

    @Override
    public <T extends Serializable> RunningWorkflowId execute(Workflow<T> workflow, T state, Duration delay) {
        TaskId<?> task = this.firstTaskRef.get(workflow);
        RunningWorkflowId id = RunningWorkflowId.newWorkflowId(workflow);
        TriggerRequest trigger = task.newTrigger(state == null ? workflow.newContext() : state).runAfter(delay).tag(this.getWorkflowId(workflow).get()).correlationId(id.value()).build();
        log.debug("Starting workflow={} with id={} and first step={}", new Object[]{workflow, id.value(), trigger.key()});
        this.persistentTaskService.runOrQueue(trigger);
        return id;
    }

    @Override
    public TriggerStatus status(RunningWorkflowId runningWorkflowId) {
        Optional status = this.persistentTaskService.findLastTriggerByCorrelationId(runningWorkflowId.value());
        if (status.isEmpty()) {
            return null;
        }
        return ((TriggerEntity)status.get()).getStatus();
    }

    @Override
    public void cancel(RunningWorkflowId runningWorkflowId) {
        TriggerSearch search = TriggerSearch.byCorrelationId((String)runningWorkflowId.value());
        List<TriggerKey> running = this.triggerService.searchTriggers(search, Pageable.ofSize((int)100)).stream().map(HasTrigger::key).toList();
        this.triggerService.cancel(running);
    }

    @Override
    public <T extends Serializable> TaskId<T> register(String workflowId, Workflow<T> workflow) throws IllegalStateException {
        TaskId firstWorkflowTask = null;
        this.workflowRepository.registerUnique(workflowId, workflow);
        for (WorkflowStep<T> step : workflow.getSteps()) {
            TaskId stepId = this.taskService.register(WorkflowHelper.stepName(workflowId, step), new WorkflowStepComponent<T>(this, this.persistentTaskService, workflowId, workflow, step));
            if (firstWorkflowTask != null) continue;
            firstWorkflowTask = stepId;
        }
        if (firstWorkflowTask == null) {
            throw new IllegalArgumentException("Workflow[id=" + workflowId + "] " + String.valueOf(workflow) + " has not steps!");
        }
        this.firstTaskRef.put(workflow, firstWorkflowTask);
        return firstWorkflowTask;
    }

    @Override
    public void clearAllWorkflows() {
        super.clearAllWorkflows();
        this.firstTaskRef.clear();
    }

    @Override
    public Optional<String> getWorkflowId(Workflow<?> workflow) {
        return this.workflowRepository.getWorkflowId(workflow);
    }

    @Override
    public <T extends Serializable> boolean resume(Workflow<T> workflow, String runnngStepId, Function<T, T> stateModifier) {
        TriggerSearch search = new TriggerSearch();
        search.setKeyId(runnngStepId);
        search.setTag(this.workflowRepository.getWorkflowId(workflow).get());
        return this.triggerService.resumeOne(search, stateModifier).isPresent();
    }

    @Override
    public <T extends Serializable> boolean resume(String runnngStepId, Function<T, T> stateModifier) {
        TriggerSearch search = new TriggerSearch();
        search.setKeyId(runnngStepId);
        return this.triggerService.resumeOne(search, stateModifier).isPresent();
    }
}

