/*
 * Decompiled with CFR 0.152.
 */
package org.sterl.pmw.spring.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.Collection;
import lombok.Generated;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.sterl.pmw.WorkflowService;
import org.sterl.pmw.WorkflowUmlService;
import org.sterl.pmw.api.WorkflowDiagram;
import org.sterl.pmw.api.WorkflowInfo;

@RequestMapping(value={"pmw-api/workflows"})
@RestController
public class WorkflowResource {
    private final WorkflowService<?> workflowService;
    private final WorkflowUmlService umlService;

    @GetMapping
    Collection<WorkflowInfo> list() {
        return this.workflowService.listWorkflows();
    }

    @Cacheable
    @GetMapping(value={"{id}"})
    WorkflowDiagram getWorkflow(@PathVariable(value="id") String id) throws IOException {
        String workflowUml = this.umlService.printWorkflow(id);
        ByteArrayOutputStream svg = new ByteArrayOutputStream();
        this.umlService.convertAsPlantUmlSvg(workflowUml, svg);
        return new WorkflowDiagram(id, workflowUml, new String(Base64.getEncoder().encode(svg.toByteArray())));
    }

    @Generated
    public WorkflowResource(WorkflowService<?> workflowService, WorkflowUmlService umlService) {
        this.workflowService = workflowService;
        this.umlService = umlService;
    }
}

