/*
 * Decompiled with CFR 0.152.
 */
package org.sterl.pmw.spring.component;

import com.github.f4b6a3.uuid.UuidCreator;
import java.io.Serializable;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;
import org.sterl.pmw.WorkflowService;
import org.sterl.pmw.command.TriggerWorkflowCommand;
import org.sterl.pmw.model.ErrorStep;
import org.sterl.pmw.model.RunningWorkflowId;
import org.sterl.pmw.model.WaitStep;
import org.sterl.pmw.model.Workflow;
import org.sterl.pmw.model.WorkflowContext;
import org.sterl.pmw.model.WorkflowStep;
import org.sterl.pmw.spring.component.WorkflowHelper;
import org.sterl.spring.persistent_tasks.PersistentTaskService;
import org.sterl.spring.persistent_tasks.api.RetryStrategy;
import org.sterl.spring.persistent_tasks.api.TaskId;
import org.sterl.spring.persistent_tasks.api.task.RunningTrigger;
import org.sterl.spring.persistent_tasks.api.task.RunningTriggerContextHolder;
import org.sterl.spring.persistent_tasks.api.task.TransactionalTask;

public class WorkflowStepComponent<T extends Serializable>
implements TransactionalTask<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowStepComponent.class);
    private final WorkflowService<?> workflowService;
    private final PersistentTaskService taskService;
    private final String workflowId;
    private final Workflow<T> workflow;
    private final WorkflowStep<T> step;

    public void accept(@Nullable T state) {
        SimpleWorkflowContext context = new SimpleWorkflowContext(RunningTriggerContextHolder.getContext());
        this.step.apply(context);
        WorkflowStep nextStep = this.selectNextStep(context, this.step);
        this.forkWorkflows(context.commands);
        if (nextStep == null) {
            return;
        }
        if (!context.canceled) {
            this.runOrQueueNextStep(context, nextStep);
        } else {
            log.info("Cancel Workflow={} {} requested in step={}.", new Object[]{this.workflow, context.state.getKey(), this.step.getId()});
            this.workflowService.cancel(new RunningWorkflowId(RunningTriggerContextHolder.getCorrelationId()));
        }
    }

    public void afterTriggerFailed(@Nullable T state, Exception e) {
        WorkflowStep<T> nextStep = this.workflow.getNextStep(this.step);
        if (nextStep instanceof ErrorStep) {
            ErrorStep errorHandler = (ErrorStep)nextStep;
            TaskId.TriggerBuilder<T> errorStep = this.toTriggerBuilder(state, errorHandler);
            this.taskService.runOrQueue(errorStep.build());
        }
    }

    public void runOrQueueNextStep(SimpleWorkflowContext<T> context, WorkflowStep<T> nextStep) {
        TaskId.TriggerBuilder<T> nextTrigger = this.toTriggerBuilder(context.data(), nextStep);
        nextTrigger.id(context.nextTaskId());
        if (context.isSuspendNext()) {
            nextTrigger.waitForSignal(OffsetDateTime.now().plus(context.getNextDelay()));
        } else {
            nextTrigger.runAfter(context.getNextDelay());
        }
        this.taskService.runOrQueue(nextTrigger.build());
    }

    public TaskId.TriggerBuilder<T> toTriggerBuilder(T data, WorkflowStep<T> nextStep) {
        return TaskId.TriggerBuilder.newTrigger((String)WorkflowHelper.stepName(this.workflowId, nextStep), data).tag(this.workflowId).correlationId(RunningTriggerContextHolder.getCorrelationId());
    }

    void forkWorkflows(List<TriggerWorkflowCommand<? extends Serializable>> commands) {
        for (TriggerWorkflowCommand<? extends Serializable> t : commands) {
            log.debug("Workflow={} triggers sub-workflow={} in={}", new Object[]{this.workflow, t.workflow(), t.delay()});
            this.workflowService.execute(t.workflow(), t.state(), t.delay());
        }
    }

    WorkflowStep<T> selectNextStep(SimpleWorkflowContext<T> c, WorkflowStep<T> currentStep) {
        if (currentStep instanceof ErrorStep) {
            return null;
        }
        WorkflowStep<T> nextStep = this.workflow.getNextStep(currentStep);
        if (nextStep instanceof WaitStep) {
            WaitStep waitFor = (WaitStep)nextStep;
            waitFor.apply(c);
            nextStep = this.selectNextStep(c, waitFor);
        }
        return nextStep;
    }

    public RetryStrategy retryStrategy() {
        return this.workflow.getRetryStrategy();
    }

    public boolean isTransactional() {
        return this.step.isTransactional();
    }

    @Generated
    public WorkflowStepComponent(WorkflowService<?> workflowService, PersistentTaskService taskService, String workflowId, Workflow<T> workflow, WorkflowStep<T> step) {
        this.workflowService = workflowService;
        this.taskService = taskService;
        this.workflowId = workflowId;
        this.workflow = workflow;
        this.step = step;
    }

    public static class SimpleWorkflowContext<T extends Serializable>
    implements WorkflowContext<T> {
        private final RunningTrigger<T> state;
        private Duration nextDelay = Duration.ZERO;
        private boolean canceled = false;
        private boolean suspendNext = false;
        private String nextTaskId = UuidCreator.getTimeOrderedEpochFast().toString();
        private List<TriggerWorkflowCommand<? extends Serializable>> commands = new ArrayList<TriggerWorkflowCommand<? extends Serializable>>();

        @Override
        public void delayNextStepBy(Duration duration) {
            this.nextDelay = duration == null ? Duration.ZERO : duration;
        }

        @Override
        public void cancelWorkflow() {
            this.canceled = true;
        }

        @Override
        public int executionCount() {
            return this.state.getExecutionCount();
        }

        @Override
        public T data() {
            return (T)this.state.getData();
        }

        @Override
        public <R extends Serializable> void addCommand(TriggerWorkflowCommand<R> command) {
            this.commands.add(command);
        }

        @Override
        public String nextTaskId() {
            return this.nextTaskId;
        }

        @Generated
        public SimpleWorkflowContext(RunningTrigger<T> state) {
            this.state = state;
        }

        @Generated
        public RunningTrigger<T> getState() {
            return this.state;
        }

        @Generated
        public Duration getNextDelay() {
            return this.nextDelay;
        }

        @Generated
        public boolean isCanceled() {
            return this.canceled;
        }

        @Generated
        public boolean isSuspendNext() {
            return this.suspendNext;
        }

        @Generated
        public String getNextTaskId() {
            return this.nextTaskId;
        }

        @Generated
        public List<TriggerWorkflowCommand<? extends Serializable>> getCommands() {
            return this.commands;
        }

        @Override
        @Generated
        public void setSuspendNext(boolean suspendNext) {
            this.suspendNext = suspendNext;
        }
    }
}

