/*
 * Decompiled with CFR 0.152.
 */
package org.sterl.pmw.uml;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import lombok.Generated;
import org.sterl.pmw.component.WorkflowRepository;
import org.sterl.pmw.model.ChooseStep;
import org.sterl.pmw.model.ErrorStep;
import org.sterl.pmw.model.TriggerWorkflowStep;
import org.sterl.pmw.model.WaitStep;
import org.sterl.pmw.model.Workflow;
import org.sterl.pmw.model.WorkflowStep;
import org.sterl.pmw.uml.DrawWorkflowStepToUml;
import org.sterl.pmw.uml.PlantUmlDiagram;

public class DrawWorkflowToUml {
    private final Workflow<?> workflow;
    private final WorkflowRepository workflowRepository;
    private final List<Consumer<PlantUmlDiagram>> finalDrawer = new ArrayList<Consumer<PlantUmlDiagram>>();

    public String draw() {
        PlantUmlDiagram diagram = new PlantUmlDiagram(this.workflow.getName());
        this.addDiagramTo(diagram);
        return diagram.build().toString();
    }

    public void addDiagramTo(PlantUmlDiagram diagram) {
        diagram.start();
        this.addDiagramStepsTo(diagram);
        diagram.stop();
    }

    public void addDiagramStepsTo(PlantUmlDiagram diagram) {
        for (WorkflowStep<?> step : this.workflow.getSteps()) {
            this.addWorkflowStepToDiagramByType(diagram, step);
        }
        this.finalDrawer.forEach(c -> c.accept(diagram));
        this.finalDrawer.clear();
    }

    private void addWorkflowStepToDiagramByType(PlantUmlDiagram diagram, WorkflowStep<?> step) {
        if (step instanceof ChooseStep) {
            ChooseStep ifStep = (ChooseStep)step;
            this.addCooseStep(ifStep, diagram);
        } else if (step instanceof WaitStep) {
            WaitStep ws = (WaitStep)step;
            this.addWait(ws, diagram);
        } else if (step instanceof ErrorStep) {
            ErrorStep er = (ErrorStep)step;
            this.error(er, diagram);
        } else if (step instanceof TriggerWorkflowStep) {
            TriggerWorkflowStep subW = (TriggerWorkflowStep)step;
            this.forkWorkflow(subW, subW.getSubWorkflow(), diagram);
        } else if (this.hasSubworkflow(step.getId()).isPresent()) {
            this.forkWorkflow(step, this.hasSubworkflow(step.getId()).get(), diagram);
        } else {
            this.draw(step, diagram);
        }
    }

    private void error(ErrorStep<?> er, PlantUmlDiagram diagram) {
        diagram.startIf("error?", "yes");
        this.addWorkflowStepToDiagramByType(diagram, er.getStep());
        diagram.appendElse("no");
        this.finalDrawer.add(d -> d.stopIf());
    }

    private Optional<Workflow<?>> hasSubworkflow(String name) {
        if (name.toLowerCase().startsWith("trigger->")) {
            String workflowId = name.substring(9, name.length());
            return this.workflowRepository.findWorkflow(workflowId);
        }
        return Optional.empty();
    }

    private void addWait(WaitStep<?> wait, PlantUmlDiagram diagram) {
        boolean isSuspend = wait.isSuspendNext();
        if (isSuspend) {
            diagram.stopIntend();
            diagram.appendLine("stop");
            diagram.appendLine("");
            diagram.appendResume(wait.getId(), wait.getDescription());
            diagram.intend();
        } else {
            diagram.appendWait(wait.getId(), wait.getDescription());
        }
    }

    private void forkWorkflow(WorkflowStep<?> s, Workflow<?> w, PlantUmlDiagram diagram) {
        diagram.line("fork");
        diagram.intend();
        this.draw(s, diagram);
        this.appendSubWorkflow(w, diagram);
        diagram.stopIntend();
        diagram.line("fork again");
        this.finalDrawer.add(d -> {
            d.stopIntend();
            d.line("end fork");
        });
    }

    private void appendSubWorkflow(Workflow<?> w, PlantUmlDiagram diagram) {
        diagram.line("partition \"" + w.getName() + "\" {");
        diagram.intend();
        new DrawWorkflowToUml(w, this.workflowRepository).addDiagramTo(diagram);
        diagram.stopIntend();
        diagram.line("}");
    }

    private void addCooseStep(ChooseStep<?> ifStep, PlantUmlDiagram diagram) {
        diagram.appendLine(ifStep.getConnectorLabel());
        diagram.startSwitch(ifStep.getId());
        AtomicInteger switchCases = new AtomicInteger(0);
        ifStep.getSubSteps().forEach((k, s) -> {
            diagram.startCase(s.getDescription());
            if (s instanceof TriggerWorkflowStep) {
                TriggerWorkflowStep tf = (TriggerWorkflowStep)s;
                diagram.labeledConnector(s.getConnectorLabel());
                this.appendSubWorkflow(tf.getSubWorkflow(), diagram);
            } else {
                this.draw((WorkflowStep<?>)s, diagram);
                switchCases.incrementAndGet();
            }
            diagram.stopCase();
        });
        if (switchCases.intValue() > 1) {
            diagram.endSwitch();
        } else {
            diagram.stopIntend();
        }
    }

    private void draw(WorkflowStep<?> s, PlantUmlDiagram diagram) {
        new DrawWorkflowStepToUml(diagram).draw(s);
    }

    @Generated
    public DrawWorkflowToUml(Workflow<?> workflow, WorkflowRepository workflowRepository) {
        this.workflow = workflow;
        this.workflowRepository = workflowRepository;
    }
}

