/*
 * Decompiled with CFR 0.152.
 */
package org.sterl.pmw.uml;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PlantUmlDiagram {
    private static final String NEW_LINE = "\n";
    private static final String START = ":";
    private static final String END = ";";
    private final List<String> diagram = new ArrayList<String>();
    private final String name;
    private final String theme;
    private int intend = 0;
    public static final String ICON_TRX = "<<T>>";
    public static final String ICON_WAIT = "<$bi-hourglass,scale=1.2>";
    public static final String ICON_RESUME = "<$bi-envelope,scale=1.2>";

    public PlantUmlDiagram(String name) {
        this(name, "!include default-skin.puml");
    }

    public PlantUmlDiagram(String name, String theme) {
        this.name = name;
        this.theme = theme;
    }

    public void intend() {
        this.intend += 2;
    }

    public void stopIntend() {
        this.intend -= 2;
    }

    public PlantUmlDiagram appendLine(String line) {
        if (line != null) {
            this.diagram.add(StringUtils.repeat((char)' ', (int)this.intend) + line);
        }
        return this;
    }

    public PlantUmlDiagram line(String value) {
        return this.appendLine(value);
    }

    public PlantUmlDiagram start() {
        this.appendLine("start");
        this.intend();
        return this;
    }

    public PlantUmlDiagram stop() {
        this.stopIntend();
        this.appendLine("stop");
        return this;
    }

    public PlantUmlDiagram appendWait(String id, String description) {
        this.appendState("<$bi-hourglass,scale=1.2> " + id, description);
        return this;
    }

    public PlantUmlDiagram appendResume(String id, String description) {
        this.appendState("<$bi-envelope,scale=1.2> " + id, description);
        return this;
    }

    public PlantUmlDiagram labeledConnector(String label) {
        if (label != null) {
            this.line("-> " + label + END);
        }
        return this;
    }

    public PlantUmlDiagram appendState(String stateName) {
        this.line(":==" + stateName + END);
        return this;
    }

    public void appendState(String id, String description) {
        if (description == null) {
            this.appendState(id);
        } else {
            this.line(":==" + id);
            this.line(description + END);
        }
    }

    public PlantUmlDiagram startSwitch(String label) {
        if (label == null) {
            this.line("switch ()");
        } else {
            this.line("switch ( " + label + " )");
        }
        this.intend();
        return this;
    }

    public PlantUmlDiagram endSwitch() {
        this.stopIntend();
        this.line("endswitch");
        return this;
    }

    public void startCase() {
        this.line("case ()");
        this.intend();
    }

    public void stopCase() {
        this.stopIntend();
    }

    public void startCase(String label) {
        if (label == null) {
            this.startCase();
        } else {
            this.line("case ( " + label + " )");
            this.intend();
        }
    }

    public StringBuilder build() {
        StringBuilder result = new StringBuilder(this.diagram.size() * 8 + 24);
        result.append("@startuml ").append("\"").append(this.name).append("\"").append(NEW_LINE);
        if (this.theme != null) {
            result.append(this.theme).append(NEW_LINE);
        }
        this.diagram.forEach(l -> result.append((String)l).append(NEW_LINE));
        result.append("@enduml");
        return result;
    }

    public void startIf(String check, String then) {
        this.appendLine("if ( " + StringUtils.stripToEmpty((String)check) + " ) then (" + StringUtils.stripToEmpty((String)then) + ")");
        this.intend();
    }

    public void stopIf() {
        this.stopIntend();
        this.appendLine("endif");
    }

    public void appendElse(String label) {
        this.stopIntend();
        this.appendLine("else ( " + StringUtils.trimToEmpty((String)label) + ")");
        this.intend();
    }
}

