/*
 * Decompiled with CFR 0.152.
 */
package org.sterl.pmw.uml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.sterl.pmw.WorkflowUmlService;
import org.sterl.pmw.model.Workflow;

public class PlantUmlWritter {
    public static void writeAsPlantUmlSvg(String filename, Workflow<? extends Serializable> workflow) throws IOException {
        File d = PlantUmlWritter.cleanExistingFile(filename);
        try (FileOutputStream out = new FileOutputStream(d);){
            new WorkflowUmlService(null).printWorkflowAsPlantUmlSvg(workflow, (OutputStream)out);
        }
    }

    public static void writeAsPlantUmlSvg(String filename, Workflow<? extends Serializable> workflow, WorkflowUmlService service) {
        File d = PlantUmlWritter.cleanExistingFile(filename);
        try (FileOutputStream out = new FileOutputStream(d);){
            service.printWorkflowAsPlantUmlSvg(workflow, (OutputStream)out);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeAsPlantUmlSvg(String filename, String name, WorkflowUmlService service) throws IOException {
        File d = PlantUmlWritter.cleanExistingFile(filename);
        try (FileOutputStream out = new FileOutputStream(d);){
            service.printWorkflowAsPlantUmlSvg(name, (OutputStream)out);
        }
    }

    private static File cleanExistingFile(String filename) {
        File d = new File(filename);
        if (d.exists()) {
            d.delete();
        }
        return d;
    }
}

