/*
 * Decompiled with CFR 0.152.
 */
package org.sterl.spring.pmw.ui;

import java.util.concurrent.TimeUnit;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.CacheControl;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.sterl.spring.persistent_tasks_ui.EnableSpringPersistentTasksUI;

@EnableSpringPersistentTasksUI
@Configuration
public class WorkflowUIConfig
implements WebMvcConfigurer {
    private static final String BASE = "/pmw-ui";
    private static final String INDEX_HTML = "forward:/pmw-ui/index.html";

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController(BASE).setViewName(INDEX_HTML);
        registry.addViewController("/pmw-ui/{path:[^\\.]*}").setViewName(INDEX_HTML);
        registry.addViewController("/pmw-ui/*/{path:[^\\\\.]*}").setViewName(INDEX_HTML);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/pmw-ui/assets/**"}).addResourceLocations(new String[]{"classpath:/static/pmw-ui/assets/"}).setCacheControl(CacheControl.maxAge((long)90L, (TimeUnit)TimeUnit.DAYS));
        registry.addResourceHandler(new String[]{"/pmw-ui/**"}).addResourceLocations(new String[]{"classpath:/static/pmw-ui/"});
    }
}

