/*
 * Decompiled with CFR 0.152.
 */
package org.sterl.test.hibernate_asserts;

import jakarta.persistence.EntityManager;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.stat.Statistics;
import org.junit.jupiter.api.Assertions;

public class HibernateAsserts {
    private final Statistics statistics;

    public HibernateAsserts(EntityManager entityManager) {
        try (Session session = (Session)entityManager.unwrap(Session.class);){
            SessionFactory factory = session.getSessionFactory();
            factory.getStatistics().setStatisticsEnabled(true);
            this.statistics = factory.getStatistics();
        }
    }

    public HibernateAsserts assertTrxCount(int expected) {
        long value = this.statistics.getTransactionCount();
        if (value != (long)expected) {
            this.logSummary();
            Assertions.fail((String)("Expected " + expected + " TransactionCount, but found " + value));
        }
        return this;
    }

    public HibernateAsserts assertInsertCount(int expected) {
        long value = this.statistics.getEntityInsertCount();
        if (value != (long)expected) {
            this.logSummary();
            Assertions.fail((String)("Expected " + expected + " EntityInsertCount, but found " + value));
        }
        return this;
    }

    public HibernateAsserts assertUpdateCount(int expected) {
        long value = this.statistics.getEntityUpdateCount();
        if (value != (long)expected) {
            this.logSummary();
            Assertions.fail((String)("Expected " + expected + " EntityUpdateCount, but found " + value));
        }
        return this;
    }

    public void reset() {
        this.statistics.clear();
    }

    public void logSummary() {
        this.statistics.logSummary();
    }
}

