/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.cli;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import org.sterling.cli.CommandLineRunner;

public final class MainRunner {
    private final Iterable<CommandLineRunner> runners;
    private final PrintStream out;

    public static void main(String[] args) {
        new MainRunner().run(Arrays.asList(args));
    }

    public MainRunner() {
        this.out = System.out;
        this.runners = ServiceLoader.load(CommandLineRunner.class);
    }

    public MainRunner(PrintStream out, Collection<CommandLineRunner> runners) {
        this.out = out;
        this.runners = new ArrayList<CommandLineRunner>(runners);
    }

    public void run(List<String> args) {
        if (args.isEmpty()) {
            this.out.println("No command specified. Available commands:");
            this.out.println();
            for (CommandLineRunner runner : this.runners) {
                this.out.println("\t" + runner.getCommand());
            }
            this.out.println();
        } else {
            CommandLineRunner foundRunner = null;
            for (CommandLineRunner runner : this.runners) {
                if (!args.get(0).equals(runner.getCommand())) continue;
                foundRunner = runner;
            }
            if (foundRunner == null) {
                this.out.println("No handler for command '" + args.get(0) + "'");
            } else {
                foundRunner.run(args.subList(1, args.size()));
            }
        }
    }
}

