/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.sterling.SterlingException;
import org.sterling.runtime.Compiler;
import org.sterling.runtime.Registry;
import org.sterling.runtime.exception.LoadModuleException;
import org.sterling.runtime.exception.UndefinedModuleException;
import org.sterling.runtime.expression.DeclaredExpression;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ExpressionFactory;
import org.sterling.runtime.expression.Repository;
import org.sterling.runtime.expression.Symbol;
import org.sterling.source.scanner.InputReader;

public class ClasspathRepository
implements Repository {
    private final Compiler compiler;
    private final Registry registry;
    private final Set<String> modules;

    public ClasspathRepository(Compiler compiler, Registry registry) {
        this.compiler = compiler;
        this.registry = registry;
        this.modules = new HashSet<String>();
    }

    public void add(DeclaredExpression declaration) throws SterlingException {
        this.registry.add(declaration);
    }

    @Override
    public boolean isDefined(Symbol symbol) {
        try {
            this.load(symbol);
            return this.registry.isDefined(symbol);
        }
        catch (SterlingException exception) {
            return false;
        }
    }

    @Override
    public Expression get(Symbol symbol) throws SterlingException {
        this.load(symbol);
        return this.registry.get(symbol);
    }

    @Override
    public Expression get(String identifier) throws SterlingException {
        return this.get(ExpressionFactory.symbol(identifier));
    }

    @Override
    public Set<DeclaredExpression> getAll() {
        return this.registry.getAll();
    }

    private void load(Symbol symbol) throws SterlingException {
        if (!this.registry.isDefined(symbol)) {
            this.loadModule(this.getModuleName(symbol));
        }
    }

    private String getModuleName(Symbol symbol) {
        String identifier = symbol.getValue();
        return identifier.substring(0, identifier.lastIndexOf(47));
    }

    private void loadModule(String moduleName) throws SterlingException {
        if (!this.modules.contains(moduleName)) {
            this.modules.add(moduleName);
            try (InputReader reader = this.readSource(moduleName);){
                this.registry.addAll(this.compiler.compile(reader, this));
            }
            catch (IOException exception) {
                throw new LoadModuleException(exception);
            }
        }
    }

    private InputReader readSource(String moduleName) throws SterlingException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource(moduleName + ".ag");
        if (url == null) {
            throw new UndefinedModuleException("Module '" + moduleName + "' not found");
        }
        return new InputReader(url.toString(), url.openStream());
    }
}

