/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sterling.SterlingException;
import org.sterling.runtime.exception.RedefinedReferenceException;
import org.sterling.runtime.exception.UndefinedReferenceException;
import org.sterling.runtime.expression.DeclaredExpression;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ExpressionFactory;
import org.sterling.runtime.expression.Repository;
import org.sterling.runtime.expression.Symbol;

public class Registry
implements Repository {
    private final Map<Symbol, DeclaredExpression> declarations = new HashMap<Symbol, DeclaredExpression>();

    public Registry add(DeclaredExpression declaration) throws SterlingException {
        if (this.isDefined(declaration.getSymbol())) {
            throw new RedefinedReferenceException("Cannot redefine reference '" + declaration.getSymbol() + "'");
        }
        this.declarations.put(declaration.getSymbol(), declaration);
        return this;
    }

    public void addAll(Set<DeclaredExpression> declarations) throws SterlingException {
        for (DeclaredExpression declaration : declarations) {
            this.add(declaration);
        }
    }

    @Override
    public boolean isDefined(Symbol symbol) {
        return this.declarations.containsKey(symbol);
    }

    @Override
    public Expression get(Symbol symbol) throws SterlingException {
        if (this.isDefined(symbol)) {
            return this.declarations.get(symbol).getExpression();
        }
        throw new UndefinedReferenceException("Reference '" + symbol.getValue() + "' is not defined");
    }

    @Override
    public Expression get(String identifier) throws SterlingException {
        return this.get(ExpressionFactory.symbol(identifier));
    }

    @Override
    public Set<DeclaredExpression> getAll() {
        return new HashSet<DeclaredExpression>(this.declarations.values());
    }
}

