/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime.expression;

import java.util.Objects;
import org.sterling.SterlingException;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ExpressionVisitor;
import org.sterling.runtime.expression.Lambda;
import org.sterling.runtime.expression.Variable;
import org.sterling.util.StringUtil;

public class Argument
extends Expression {
    private final Variable variable;
    private final Expression expression;

    public Argument(Variable variable, Expression expression) {
        this.variable = variable;
        this.expression = expression;
    }

    @Override
    public <R, D> R accept(ExpressionVisitor<R, D> visitor, D data) throws SterlingException {
        return visitor.visitArgumentExpression(this, data);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Argument) {
            Argument other = (Argument)o;
            return Objects.equals(this.variable, other.variable) && Objects.equals(this.expression, other.expression);
        }
        return false;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public int hashCode() {
        return Objects.hash(this.variable, this.expression);
    }

    public boolean isApplicableTo(Lambda lambda) {
        return !this.variable.equals(lambda.getVariable());
    }

    public boolean replaces(Expression expression) {
        return this.variable.equals(expression);
    }

    public String toString() {
        return StringUtil.stringify(this, this.variable, this.expression);
    }
}

