/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime.expression;

import java.io.PrintStream;
import org.sterling.SterlingException;
import org.sterling.runtime.expression.AccessedExpression;
import org.sterling.runtime.expression.AppliedExpression;
import org.sterling.runtime.expression.Argument;
import org.sterling.runtime.expression.BoundExpression;
import org.sterling.runtime.expression.DeclaredExpression;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ExpressionVisitor;
import org.sterling.runtime.expression.Lambda;
import org.sterling.runtime.expression.ObjectExpression;
import org.sterling.runtime.expression.Reference;
import org.sterling.util.PrinterState;

public class ExpressionPrinter
implements ExpressionVisitor<Void, PrinterState> {
    private final int initialIndent;

    public ExpressionPrinter(int initialIndent) {
        this.initialIndent = initialIndent;
    }

    public void print(Expression expression, PrintStream out) throws SterlingException {
        this.visit(expression, new PrinterState(out, this.initialIndent));
    }

    @Override
    public Void visit(Expression expression, PrinterState state) throws SterlingException {
        expression.accept(this, state);
        return null;
    }

    @Override
    public Void visitAccessExpression(AccessedExpression expression, PrinterState state) throws SterlingException {
        state.begin(expression);
        this.visit(expression.getExpression(), state);
        this.visit(expression.getMember(), state);
        state.end();
        return null;
    }

    @Override
    public Void visitApplyExpression(AppliedExpression expression, PrinterState state) throws SterlingException {
        state.begin(expression);
        this.visit(expression.getExpression(), state);
        this.visit(expression.getArgument(), state);
        state.end();
        return null;
    }

    @Override
    public Void visitArgumentExpression(Argument expression, PrinterState state) throws SterlingException {
        state.begin(expression);
        this.visit(expression.getExpression(), state);
        state.end();
        return null;
    }

    @Override
    public Void visitBindExpression(BoundExpression expression, PrinterState state) throws SterlingException {
        state.begin(expression);
        this.visit(expression.getExpression(), state);
        this.visit((Expression)expression.getArgument(), state);
        state.end();
        return null;
    }

    @Override
    public Void visitLambda(Lambda lambda, PrinterState state) throws SterlingException {
        state.begin(lambda);
        this.visit((Expression)lambda.getVariable(), state);
        this.visit(lambda.getExpression(), state);
        state.end();
        return null;
    }

    @Override
    public Void visitObjectExpression(ObjectExpression object, PrinterState state) throws SterlingException {
        state.begin(object);
        for (DeclaredExpression declaration : object.getMembers()) {
            state.println("Member <<" + declaration.getIdentifier() + ">>");
            this.visit(declaration.getExpression(), state);
        }
        state.end();
        return null;
    }

    @Override
    public Void visitPrimaryExpression(Expression expression, PrinterState state) throws SterlingException {
        state.println(expression.toString());
        return null;
    }

    @Override
    public Void visitReference(Reference reference, PrinterState state) throws SterlingException {
        state.println("Reference <<" + reference.getSymbol() + ">>");
        return null;
    }
}

