/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime.expression;

import org.sterling.SterlingException;
import org.sterling.runtime.expression.BooleanConstant;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ExpressionConversions;
import org.sterling.runtime.expression.ExpressionFactory;
import org.sterling.runtime.expression.IntegerConstant;
import org.sterling.runtime.expression.StringConstant;
import org.sterling.util.StringUtil;

public class NullConstant
extends Expression {
    public static final NullConstant NULL = new NullConstant();
    private final BooleanConstant booleanValue = ExpressionFactory.constant(false);
    private final IntegerConstant integerValue = ExpressionFactory.constant(0);
    private final StringConstant stringValue = ExpressionFactory.constant("nothing");

    private NullConstant() {
    }

    @Override
    public Expression access(Expression member) throws SterlingException {
        switch (ExpressionConversions.convertSymbol(member).getValue()) {
            case "isNothing": {
                return BooleanConstant.TRUE;
            }
            case "toBoolean": {
                return this.booleanValue;
            }
            case "toInteger": {
                return this.integerValue;
            }
            case "toString": {
                return this.stringValue;
            }
        }
        return super.access(member);
    }

    public String toString() {
        return StringUtil.stringify(this, new Object[0]);
    }
}

