/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.sterling.SterlingException;
import org.sterling.runtime.expression.DeclaredExpression;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ExpressionConversions;
import org.sterling.runtime.expression.ExpressionFactory;
import org.sterling.runtime.expression.ExpressionVisitor;
import org.sterling.runtime.expression.Symbol;
import org.sterling.util.StringUtil;

public class ObjectExpression
extends Expression {
    private final Map<Symbol, Expression> members;

    public ObjectExpression(Set<DeclaredExpression> members) {
        HashMap<Symbol, Expression> map = new HashMap<Symbol, Expression>();
        for (DeclaredExpression declaration : members) {
            map.put(declaration.getSymbol(), declaration.getExpression());
        }
        this.members = new ConcurrentHashMap<Symbol, Expression>(map);
    }

    @Override
    public <R, D> R accept(ExpressionVisitor<R, D> visitor, D data) throws SterlingException {
        return visitor.visitObjectExpression(this, data);
    }

    @Override
    public Expression access(Expression member) throws SterlingException {
        Symbol symbol = ExpressionConversions.convertSymbol(member);
        if (this.members.containsKey(symbol)) {
            return this.members.get(symbol);
        }
        return super.access(symbol);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof ObjectExpression && this.members.equals(((ObjectExpression)o).members);
    }

    public Set<DeclaredExpression> getMembers() {
        HashSet<DeclaredExpression> declarations = new HashSet<DeclaredExpression>();
        for (Symbol symbol : this.members.keySet()) {
            declarations.add(ExpressionFactory.declaration(symbol, this.members.get(symbol)));
        }
        return declarations;
    }

    public int hashCode() {
        return Objects.hash(this.members);
    }

    public String toString() {
        ArrayList<DeclaredExpression> declarations = new ArrayList<DeclaredExpression>();
        for (Symbol symbol : this.members.keySet()) {
            declarations.add(ExpressionFactory.declaration(symbol, this.members.get(symbol)));
        }
        Collections.sort(declarations, new DeclarationComparator());
        return StringUtil.stringify(this, declarations);
    }

    private static final class DeclarationComparator
    implements Comparator<DeclaredExpression> {
        private DeclarationComparator() {
        }

        @Override
        public int compare(DeclaredExpression o1, DeclaredExpression o2) {
            return o1.getSymbol().getValue().compareTo(o2.getSymbol().getValue());
        }
    }
}

