/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.runtime.expression;

import java.util.Objects;
import org.sterling.SterlingException;
import org.sterling.runtime.expression.Expression;
import org.sterling.runtime.expression.ExpressionVisitor;
import org.sterling.runtime.expression.Repository;
import org.sterling.runtime.expression.Symbol;
import org.sterling.util.StringUtil;

public class Reference
extends Expression {
    private final Symbol symbol;
    private final Repository repository;

    public Reference(Symbol symbol) {
        this.symbol = symbol;
        this.repository = null;
    }

    public Reference(Symbol symbol, Repository repository) {
        this.symbol = symbol;
        this.repository = repository;
    }

    @Override
    public <R, D> R accept(ExpressionVisitor<R, D> visitor, D data) throws SterlingException {
        return visitor.visitReference(this, data);
    }

    @Override
    public Expression apply(Expression argument) throws SterlingException {
        return this.reduce().apply(argument);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof Reference && Objects.equals(this.symbol, ((Reference)o).symbol);
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public int hashCode() {
        return Objects.hash(this.symbol);
    }

    @Override
    public Expression reduce() throws SterlingException {
        return this.repository.get(this.symbol);
    }

    public String toString() {
        return StringUtil.stringify(this, "'" + this.symbol + "'");
    }

    @Override
    protected boolean isReducible() {
        return true;
    }
}

