/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source.parser;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.sterling.SterlingException;
import org.sterling.cli.CommandLineRunner;
import org.sterling.cli.RunnerException;
import org.sterling.source.parser.Parser;
import org.sterling.source.parser.ParserRunnerProperties;
import org.sterling.source.scanner.InputReader;
import org.sterling.source.scanner.ScannerFactory;
import org.sterling.source.syntax.SourcePrinter;
import org.sterling.util.BufferUtil;

public class ParserRunner
implements CommandLineRunner {
    private final BufferedReader input;
    private final PrintStream output;
    private final Parser parser;
    private final ScannerFactory scannerFactory;
    private final SourcePrinter printer;

    public ParserRunner() {
        this(new ParserRunnerProperties().setInput(BufferUtil.buffer(System.in)).setOutput(System.out).setParser(new Parser()).setPrinter(new SourcePrinter()).setScannerFactory(new ScannerFactory()));
    }

    public ParserRunner(ParserRunnerProperties properties) {
        this.input = properties.getInput();
        this.output = properties.getOutput();
        this.parser = properties.getParser();
        this.scannerFactory = properties.getScannerFactory();
        this.printer = properties.getPrinter();
    }

    @Override
    public String getCommand() {
        return "parse";
    }

    public void run() {
        this.run(new ArrayList<String>());
    }

    @Override
    public void run(List<String> args) {
        this.output.println("Type any input to see how it parses:");
        this.output.print(">>> ");
        try {
            String input;
            while (null != (input = this.input.readLine()) && !"quit".equals(input)) {
                if (!"".equals(input.trim())) {
                    try {
                        this.printer.print(this.parser.parse(this.scannerFactory.getScanner(new InputReader("Command Line", new ByteArrayInputStream(input.getBytes("UTF-8"))))), this.output);
                    }
                    catch (SterlingException exception) {
                        exception.printStackTrace(this.output);
                    }
                }
                this.output.print(">>> ");
            }
        }
        catch (IOException exception) {
            throw new RunnerException(exception);
        }
        this.output.println("Goodbye!");
    }
}

