/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source.parser;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.sterling.SterlingException;
import org.sterling.source.exception.ParserException;
import org.sterling.source.exception.ScannerException;
import org.sterling.source.parser.ParserAction;
import org.sterling.source.parser.ParserState;
import org.sterling.source.parser.ParserTable;
import org.sterling.source.scanner.Scanner;
import org.sterling.source.syntax.NodeKind;
import org.sterling.source.syntax.SourceNode;

public class TableDrivenParser {
    private static final ParserAction MATCH = new ParserAction(){

        @Override
        public void invoke(TableDrivenParser parser) throws SterlingException {
            parser.match();
        }
    };
    private final Scanner scanner;
    private final ParserTable table;
    private final Deque<SourceNode> stack;
    private final TryManager tries;

    public TableDrivenParser(NodeKind firstKind, ParserTable table, Scanner scanner) {
        this.table = table;
        this.scanner = scanner;
        this.stack = new ArrayDeque<SourceNode>();
        this.tries = new TryManager();
        this.stack.push(firstKind.createNode());
    }

    public void error() throws SterlingException {
        if (!this.tries.handleError()) {
            try {
                this.scanner.requireOne(this.getPossibleLookAhead());
            }
            catch (ScannerException exception) {
                throw new ParserException("Parse error in " + (Object)((Object)this.peek().getKind()), exception);
            }
        }
    }

    public ParserAction getAction() {
        ParserAction action = this.table.getErrorAction();
        if (this.peek().isTerminal()) {
            if (this.scanner.expect(this.peek().getKind())) {
                action = MATCH;
            }
        } else {
            action = this.table.getAction(this.getState());
        }
        return action;
    }

    public NodeKind getLookAhead() {
        return this.scanner.expected(this.getPossibleLookAhead());
    }

    public ParserState getState() {
        return ParserState.state(this.peek().getKind(), this.getLookAhead());
    }

    public void match() throws SterlingException {
        this.peek().setToken(this.scanner.require(this.getState().getStack()));
        this.output();
    }

    public SourceNode output() {
        return this.stack.pop();
    }

    public SourceNode parse() throws SterlingException {
        SourceNode root = this.stack.peek();
        while (this.stack.size() > 0) {
            this.getAction().invoke(this);
        }
        root.prune();
        return root;
    }

    public SourceNode peek() {
        return this.stack.peek();
    }

    public void push(SourceNode node) {
        this.stack.push(node);
        this.tries.handlePush(node);
    }

    private void backtrack(SourceNode parent) {
        while (this.peek().childOf(parent)) {
            this.output();
        }
        parent.clearChildren();
        this.scanner.restore();
    }

    private void begin() {
        this.scanner.begin();
    }

    private void beginTry(List<Derive> derivations) {
        this.tries.begin(this, this.output(), derivations);
    }

    private void end() {
        this.scanner.end();
    }

    private List<NodeKind> getPossibleLookAhead() {
        if (this.peek().isTerminal()) {
            return Arrays.asList(this.peek().getKind());
        }
        return this.table.getLookAhead(this.peek());
    }

    private static final class TryState {
        private final TableDrivenParser parser;
        private final SourceNode parent;
        private final Iterator<Derive> derivations;

        public TryState(TableDrivenParser parser, SourceNode parent, List<Derive> derivations) {
            this.parser = parser;
            this.parent = parent;
            this.derivations = derivations.iterator();
        }

        public void begin() {
            this.parser.begin();
            this.derivations.next().derive(this.parser, this.parent);
        }

        public boolean handleError() {
            if (this.derivations.hasNext()) {
                this.parser.backtrack(this.parent);
                this.begin();
                return true;
            }
            return false;
        }

        public boolean handlePush(SourceNode node) {
            if (node.childOf(this.parent)) {
                return false;
            }
            this.parser.end();
            return true;
        }
    }

    private static final class TryManager {
        private final Deque<TryState> tries = new ArrayDeque<TryState>();

        public void begin(TableDrivenParser parser, SourceNode parent, List<Derive> derivations) {
            this.push(new TryState(parser, parent, derivations));
            this.currentTry().begin();
        }

        public boolean handleError() {
            return this.hasTries() && this.currentTry().handleError();
        }

        public void handlePush(SourceNode node) {
            if (this.hasTries() && this.currentTry().handlePush(node)) {
                this.tries.pop();
            }
        }

        public void push(TryState state) {
            this.tries.push(state);
        }

        private TryState currentTry() {
            return this.tries.peek();
        }

        private boolean hasTries() {
            return this.tries.size() > 0;
        }
    }

    public static class TryDerive
    implements ParserAction {
        private final List<Derive> derivations;

        public TryDerive(NodeKind ... stacks) {
            this.derivations = new ArrayList<Derive>(stacks.length);
            for (NodeKind stack : stacks) {
                this.derivations.add(new Derive(stack));
            }
        }

        @Override
        public void invoke(TableDrivenParser parser) throws ParserException {
            parser.beginTry(this.derivations);
        }
    }

    public static class Derive
    implements ParserAction {
        private final List<NodeKind> kinds;

        public Derive(NodeKind ... kinds) {
            this.kinds = Arrays.asList(kinds);
        }

        public void derive(TableDrivenParser parser, SourceNode parent) {
            ArrayDeque<SourceNode> children = new ArrayDeque<SourceNode>();
            for (NodeKind kind : this.kinds) {
                SourceNode child = kind.createNode();
                parent.addChild(child);
                children.push(child);
            }
            while (children.size() > 0) {
                parser.push((SourceNode)children.pop());
            }
        }

        @Override
        public void invoke(TableDrivenParser parser) throws ParserException {
            this.derive(parser, parser.output());
        }
    }
}

