/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source.scanner;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.sterling.SterlingException;
import org.sterling.source.scanner.InputReader;
import org.sterling.source.scanner.Scanner;
import org.sterling.source.scanner.ScannerDelegate;
import org.sterling.source.scanner.ScannerUtil;
import org.sterling.source.syntax.NodeKind;
import org.sterling.source.syntax.Token;

public class DelegatingScanner
implements Scanner {
    private final InputReader reader;
    private final Map<NodeKind, ScannerDelegate> delegates;

    public DelegatingScanner(InputReader reader, Map<NodeKind, ScannerDelegate> delegates) {
        this.reader = reader;
        this.delegates = new HashMap<NodeKind, ScannerDelegate>(delegates);
    }

    @Override
    public void begin() {
        this.reader.begin();
    }

    @Override
    public void close() {
        this.reader.close();
    }

    @Override
    public void end() {
        this.reader.end();
    }

    @Override
    public boolean expect(NodeKind kind) {
        if (this.delegates.containsKey((Object)kind)) {
            return this.delegates.get((Object)kind).expect(kind, this.reader);
        }
        if (NodeKind.ANYTHING == kind) {
            return true;
        }
        throw new IllegalArgumentException("No delegate registered to token kind " + (Object)((Object)kind));
    }

    @Override
    public boolean expectOne(NodeKind ... kinds) {
        return this.expectOne(Arrays.asList(kinds));
    }

    @Override
    public boolean expectOne(Iterable<NodeKind> kinds) {
        return NodeKind.ANYTHING != this.expected(kinds);
    }

    @Override
    public NodeKind expected(Iterable<NodeKind> kinds) {
        for (NodeKind kind : kinds) {
            if (!this.expect(kind)) continue;
            return kind;
        }
        return NodeKind.ANYTHING;
    }

    @Override
    public NodeKind expected(NodeKind ... kinds) {
        return this.expected(Arrays.asList(kinds));
    }

    @Override
    public Token require(NodeKind kind) throws SterlingException {
        if (this.expect(kind)) {
            return this.delegates.get((Object)kind).require(kind, this.reader);
        }
        throw ScannerUtil.unexpectedInput(this.reader, kind);
    }

    @Override
    public Token requireOne(NodeKind ... kinds) throws SterlingException {
        return this.requireOne(Arrays.asList(kinds));
    }

    @Override
    public Token requireOne(Collection<NodeKind> kinds) throws SterlingException {
        for (NodeKind kind : kinds) {
            if (!this.expect(kind)) continue;
            return this.require(kind);
        }
        throw ScannerUtil.unexpectedInput(this.reader, kinds);
    }

    @Override
    public void restore() {
        this.reader.rollback();
    }
}

