/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source.scanner;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sterling.source.Location;
import org.sterling.source.LocationRange;
import org.sterling.source.exception.InputException;
import org.sterling.source.exception.NoAcceptedInputException;
import org.sterling.source.exception.NoMoreInputException;
import org.sterling.source.scanner.StateManager;
import org.sterling.source.syntax.NodeKind;
import org.sterling.source.syntax.Token;
import org.sterling.util.BufferUtil;

public class InputReader
implements AutoCloseable {
    private final String source;
    private final BufferedReader reader;
    private final Deque<InputReference> readBuffer;
    private final Deque<StoredReference> storeBuffer;
    private final StateManager<InputReference> stateManager;
    private final Pattern whitespace;
    private String input;
    private int line;
    private int column;

    public InputReader(String source, InputStream inputStream) {
        this.source = source;
        this.reader = BufferUtil.buffer(inputStream);
        this.readBuffer = new ArrayDeque<InputReference>();
        this.storeBuffer = new ArrayDeque<StoredReference>();
        this.stateManager = new StateManager<InputReference>(this.readBuffer);
        this.whitespace = Pattern.compile("^\\s+");
        this.line = -1;
        this.column = 0;
    }

    public Token accept(NodeKind kind) {
        Deque<StoredReference> acceptedReferences = this.acceptReferences();
        Location start = acceptedReferences.peek().getLocation();
        Location end = acceptedReferences.peekLast().getLocation();
        StringBuilder builder = new StringBuilder();
        while (!acceptedReferences.isEmpty()) {
            builder.append(acceptedReferences.pop().getValue());
        }
        return Token.token(kind, builder.toString(), LocationRange.between(start, Location.at(end.getSource(), end.getLine(), end.getColumn() + 1)));
    }

    public void begin() {
        this.stateManager.begin();
    }

    @Override
    public void close() {
        try {
            this.stateManager.close();
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void end() {
        this.stateManager.end();
    }

    public boolean expect(char value) {
        return this.peek() == value;
    }

    public boolean expect(Pattern ... patterns) {
        if (this.hasMore()) {
            for (Pattern pattern : patterns) {
                if (!this.match(pattern).find()) continue;
                return true;
            }
        }
        return false;
    }

    public Location getLocation() {
        this.hasMore();
        InputReference reference = this.peekReference();
        if (reference == null) {
            return Location.at(this.source, this.line, this.column);
        }
        return reference.getLocation();
    }

    public char peek() {
        if (this.hasMore()) {
            return this.peekReference().getValue();
        }
        return '\u0000';
    }

    public void reject() {
        while (!this.storeBuffer.isEmpty()) {
            this.backward();
        }
    }

    public void rollback() {
        this.stateManager.restore();
    }

    public void skip() {
        this.forward(true);
    }

    public void skip(Pattern pattern) {
        Matcher matcher = this.match(pattern);
        if (matcher.find()) {
            int length = matcher.group(0).length();
            for (int i = 0; i < length; ++i) {
                this.skip();
            }
        }
    }

    public void skipWhitespace() {
        while (Character.isWhitespace(this.peek())) {
            this.skip(this.whitespace);
        }
    }

    public void store() {
        this.forward();
    }

    public void store(int thisMany) {
        for (int i = 0; i < thisMany; ++i) {
            this.store();
        }
    }

    public boolean store(Pattern ... patterns) {
        for (Pattern pattern : patterns) {
            Matcher matcher = this.match(pattern);
            if (!matcher.find()) continue;
            this.store(matcher.group(0).length());
            return true;
        }
        return false;
    }

    private Deque<StoredReference> acceptReferences() {
        ArrayDeque<StoredReference> acceptedInput = new ArrayDeque<StoredReference>();
        for (StoredReference reference : this.storeBuffer) {
            if (!reference.isKeep()) continue;
            acceptedInput.push(reference);
        }
        if (acceptedInput.isEmpty()) {
            throw new NoAcceptedInputException();
        }
        this.storeBuffer.clear();
        return acceptedInput;
    }

    private void backward() {
        this.readBuffer.push(this.storeBuffer.pop().getReference());
    }

    private void forward() {
        this.forward(false);
    }

    private void forward(boolean skip) {
        if (!this.hasMore()) {
            throw new NoMoreInputException("No more input [" + this.getLocation() + "]");
        }
        InputReference next = this.readBuffer.pop();
        this.stateManager.push(next);
        this.storeBuffer.push(new StoredReference(next, skip));
    }

    private String getCurrentLine() {
        StringBuilder builder = new StringBuilder();
        int offset = this.getLocation().getColumn();
        for (InputReference reference : this.readBuffer) {
            builder.append(reference.getValue());
            offset = reference.getLocation().getColumn();
        }
        if (this.input != null) {
            builder.append(this.input.substring(offset + 1));
        }
        return builder.toString();
    }

    private String getLine() {
        if (this.hasMore()) {
            if (this.getLocation().getLine() == this.line) {
                return this.getCurrentLine();
            }
            return this.getPreviousLine();
        }
        return "\u0000";
    }

    private String getPreviousLine() {
        StringBuilder builder = new StringBuilder();
        for (InputReference reference : this.readBuffer) {
            if (reference.getLocation().getLine() == this.line) continue;
            builder.append(reference.getValue());
        }
        return builder.toString();
    }

    private boolean hasLine() {
        if (this.input == null || this.column >= this.input.length()) {
            try {
                this.input = this.reader.readLine();
            }
            catch (IOException exception) {
                throw new InputException(exception);
            }
            if (this.input != null) {
                this.input = this.input + "\n";
                this.column = 0;
                ++this.line;
            }
        }
        return this.input != null;
    }

    private boolean hasMore() {
        if (this.readBuffer.isEmpty()) {
            if (this.hasLine()) {
                this.readBuffer.push(new InputReference(Location.at(this.source, this.line, this.column), this.input.charAt(this.column++)));
            } else {
                return false;
            }
        }
        return true;
    }

    private Matcher match(Pattern pattern) {
        return pattern.matcher(this.getLine());
    }

    private InputReference peekReference() {
        return this.readBuffer.peek();
    }

    private static final class StoredReference {
        private final InputReference reference;
        private final boolean discard;

        public StoredReference(InputReference reference, boolean discard) {
            this.reference = reference;
            this.discard = discard;
        }

        public Location getLocation() {
            return this.reference.getLocation();
        }

        public InputReference getReference() {
            return this.reference;
        }

        public char getValue() {
            return this.reference.getValue();
        }

        public boolean isKeep() {
            return !this.discard;
        }
    }

    private static final class InputReference {
        private final Location location;
        private final char value;

        public InputReference(Location location, char value) {
            this.location = location;
            this.value = value;
        }

        public Location getLocation() {
            return this.location;
        }

        public char getValue() {
            return this.value;
        }
    }
}

