/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source.scanner;

import java.util.regex.Pattern;
import org.sterling.source.scanner.BooleanScanner;
import org.sterling.source.scanner.CharacterScanner;
import org.sterling.source.scanner.DoubleScanner;
import org.sterling.source.scanner.EndOfInputScanner;
import org.sterling.source.scanner.IdentifierScanner;
import org.sterling.source.scanner.IntegerScanner;
import org.sterling.source.scanner.ScannerDelegate;
import org.sterling.source.scanner.StaticTokenScanner;
import org.sterling.source.scanner.StringScanner;
import org.sterling.source.scanner.TerminatorScanner;
import org.sterling.source.scanner.WhitespaceSkippingScanner;

public class ScannerDelegateFactory {
    private static ScannerDelegate skipWhitespace(String ... values) {
        return ScannerDelegateFactory.skipWhitespace(new StaticTokenScanner(values));
    }

    private static ScannerDelegate skipWhitespace(ScannerDelegate delegate) {
        return new WhitespaceSkippingScanner(delegate);
    }

    public ScannerDelegate getAccessorScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("."));
    }

    public ScannerDelegate getAddScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("+"));
    }

    public ScannerDelegate getApplyScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("$"));
    }

    public ScannerDelegate getArrowScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("->"));
    }

    public ScannerDelegate getAssignScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("="));
    }

    public ScannerDelegate getBitwiseAndScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("&"));
    }

    public ScannerDelegate getBitwiseNotScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("~"));
    }

    public ScannerDelegate getBitwiseOrScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("|"));
    }

    public ScannerDelegate getBitwiseXorScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("^"));
    }

    public ScannerDelegate getBlockCloseScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("}"));
    }

    public ScannerDelegate getBlockOpenScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("{"));
    }

    public ScannerDelegate getBooleanScanner() {
        return ScannerDelegateFactory.skipWhitespace(new BooleanScanner());
    }

    public ScannerDelegate getCharacterScanner() {
        return ScannerDelegateFactory.skipWhitespace(new CharacterScanner());
    }

    public ScannerDelegate getCoalesceScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("?"));
    }

    public ScannerDelegate getDivideScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("/"));
    }

    public ScannerDelegate getDoubleScanner() {
        return ScannerDelegateFactory.skipWhitespace(new DoubleScanner());
    }

    public ScannerDelegate getEndOfInputScanner() {
        return ScannerDelegateFactory.skipWhitespace(new EndOfInputScanner());
    }

    public ScannerDelegate getEqualsScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("="), "is\\b");
    }

    public ScannerDelegate getGreaterThanEqualsScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote(">="));
    }

    public ScannerDelegate getGreaterThanScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote(">"));
    }

    public ScannerDelegate getGroupCloseScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote(")"));
    }

    public ScannerDelegate getGroupOpenScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("("));
    }

    public ScannerDelegate getIdentifierScanner() {
        return ScannerDelegateFactory.skipWhitespace(new IdentifierScanner());
    }

    public ScannerDelegate getIndexerCloseScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("]"));
    }

    public ScannerDelegate getIndexerOpenScanner() {
        return new StaticTokenScanner(Pattern.quote("["));
    }

    public ScannerDelegate getIndexerOperatorScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("[]"));
    }

    public ScannerDelegate getIntegerScanner() {
        return ScannerDelegateFactory.skipWhitespace(new IntegerScanner());
    }

    public ScannerDelegate getKeywordAsScanner() {
        return ScannerDelegateFactory.skipWhitespace("as\\b");
    }

    public ScannerDelegate getKeywordFromScanner() {
        return ScannerDelegateFactory.skipWhitespace("from\\b");
    }

    public ScannerDelegate getKeywordIfScanner() {
        return ScannerDelegateFactory.skipWhitespace("if\\b");
    }

    public ScannerDelegate getKeywordImportScanner() {
        return ScannerDelegateFactory.skipWhitespace("import\\b");
    }

    public ScannerDelegate getKeywordModuleScanner() {
        return ScannerDelegateFactory.skipWhitespace("module\\b");
    }

    public ScannerDelegate getKeywordNegativeScanner() {
        return ScannerDelegateFactory.skipWhitespace("negative\\b");
    }

    public ScannerDelegate getKeywordObjectScanner() {
        return ScannerDelegateFactory.skipWhitespace("object\\b");
    }

    public ScannerDelegate getKeywordPositiveScanner() {
        return ScannerDelegateFactory.skipWhitespace("positive\\b");
    }

    public ScannerDelegate getLessThanEqualsScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("<="));
    }

    public ScannerDelegate getLessThanScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("<"));
    }

    public ScannerDelegate getLogicalAndScanner() {
        return ScannerDelegateFactory.skipWhitespace("and\\b");
    }

    public ScannerDelegate getLogicalNotScanner() {
        return ScannerDelegateFactory.skipWhitespace("not\\b");
    }

    public ScannerDelegate getLogicalOrScanner() {
        return ScannerDelegateFactory.skipWhitespace("or\\b");
    }

    public ScannerDelegate getModuloScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("%"), "mod\\b");
    }

    public ScannerDelegate getMultiplyScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("*"));
    }

    public ScannerDelegate getNegativeScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("-"));
    }

    public ScannerDelegate getNotEqualsScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("<>"), "is\\s+not\\b");
    }

    public ScannerDelegate getNullScanner() {
        return ScannerDelegateFactory.skipWhitespace("nothing\\b");
    }

    public ScannerDelegate getPositiveScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("+"));
    }

    public ScannerDelegate getSeparatorScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote(","));
    }

    public ScannerDelegate getShiftLeftScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("<<"));
    }

    public ScannerDelegate getShiftRightScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote(">>>"));
    }

    public ScannerDelegate getSignedShiftRightScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote(">>"));
    }

    public ScannerDelegate getStringScanner() {
        return ScannerDelegateFactory.skipWhitespace(new StringScanner());
    }

    public ScannerDelegate getSubtractScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("-"));
    }

    public ScannerDelegate getTerminatorScanner() {
        return new TerminatorScanner();
    }

    public ScannerDelegate getTernaryFalseScanner() {
        return ScannerDelegateFactory.skipWhitespace("else\\b");
    }

    public ScannerDelegate getTernaryTrueScanner() {
        return ScannerDelegateFactory.skipWhitespace("then\\b");
    }

    public ScannerDelegate getWildcardScanner() {
        return ScannerDelegateFactory.skipWhitespace(Pattern.quote("*"));
    }
}

