/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source.scanner;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.sterling.source.scanner.DelegatingScanner;
import org.sterling.source.scanner.InputReader;
import org.sterling.source.scanner.Scanner;
import org.sterling.source.scanner.ScannerDelegate;
import org.sterling.source.scanner.ScannerDelegateFactory;
import org.sterling.source.syntax.NodeKind;

public class ScannerFactory {
    public Scanner getScanner(InputReader inputReader) {
        return new DelegatingScanner(inputReader, Holder.delegates);
    }

    private static final class Holder {
        private static final Map<NodeKind, ScannerDelegate> delegates;

        private Holder() {
        }

        static {
            ScannerDelegateFactory factory = new ScannerDelegateFactory();
            HashMap<NodeKind, ScannerDelegate> map = new HashMap<NodeKind, ScannerDelegate>();
            map.put(NodeKind.IDENTIFIER, factory.getIdentifierScanner());
            map.put(NodeKind.INTEGER, factory.getIntegerScanner());
            map.put(NodeKind.DOUBLE, factory.getDoubleScanner());
            map.put(NodeKind.ADD, factory.getAddScanner());
            map.put(NodeKind.SUBTRACT, factory.getSubtractScanner());
            map.put(NodeKind.MULTIPLY, factory.getMultiplyScanner());
            map.put(NodeKind.DIVIDE, factory.getDivideScanner());
            map.put(NodeKind.MODULO, factory.getModuloScanner());
            map.put(NodeKind.POSITIVE, factory.getPositiveScanner());
            map.put(NodeKind.NEGATIVE, factory.getNegativeScanner());
            map.put(NodeKind.SHIFT_LEFT, factory.getShiftLeftScanner());
            map.put(NodeKind.SHIFT_RIGHT, factory.getShiftRightScanner());
            map.put(NodeKind.SIGNED_SHIFT_RIGHT, factory.getSignedShiftRightScanner());
            map.put(NodeKind.ACCESSOR, factory.getAccessorScanner());
            map.put(NodeKind.COALESCE, factory.getCoalesceScanner());
            map.put(NodeKind.BITWISE_AND, factory.getBitwiseAndScanner());
            map.put(NodeKind.BITWISE_OR, factory.getBitwiseOrScanner());
            map.put(NodeKind.BITWISE_XOR, factory.getBitwiseXorScanner());
            map.put(NodeKind.LOGICAL_AND, factory.getLogicalAndScanner());
            map.put(NodeKind.LOGICAL_OR, factory.getLogicalOrScanner());
            map.put(NodeKind.LOGICAL_NOT, factory.getLogicalNotScanner());
            map.put(NodeKind.GREATER_THAN, factory.getGreaterThanScanner());
            map.put(NodeKind.LESS_THAN, factory.getLessThanScanner());
            map.put(NodeKind.GREATER_THAN_EQUALS, factory.getGreaterThanEqualsScanner());
            map.put(NodeKind.LESS_THAN_EQUALS, factory.getLessThanEqualsScanner());
            map.put(NodeKind.EQUALS, factory.getEqualsScanner());
            map.put(NodeKind.NOT_EQUALS, factory.getNotEqualsScanner());
            map.put(NodeKind.ASSIGN, factory.getAssignScanner());
            map.put(NodeKind.BITWISE_NOT, factory.getBitwiseNotScanner());
            map.put(NodeKind.GROUP_OPEN, factory.getGroupOpenScanner());
            map.put(NodeKind.GROUP_CLOSE, factory.getGroupCloseScanner());
            map.put(NodeKind.INDEXER_OPEN, factory.getIndexerOpenScanner());
            map.put(NodeKind.INDEXER_CLOSE, factory.getIndexerCloseScanner());
            map.put(NodeKind.TERNARY_TRUE, factory.getTernaryTrueScanner());
            map.put(NodeKind.TERNARY_FALSE, factory.getTernaryFalseScanner());
            map.put(NodeKind.BOOLEAN, factory.getBooleanScanner());
            map.put(NodeKind.STRING, factory.getStringScanner());
            map.put(NodeKind.NOTHING, factory.getNullScanner());
            map.put(NodeKind.CHARACTER, factory.getCharacterScanner());
            map.put(NodeKind.TERMINATOR, factory.getTerminatorScanner());
            map.put(NodeKind.BLOCK_OPEN, factory.getBlockOpenScanner());
            map.put(NodeKind.BLOCK_CLOSE, factory.getBlockCloseScanner());
            map.put(NodeKind.END_OF_INPUT, factory.getEndOfInputScanner());
            map.put(NodeKind.ARROW, factory.getArrowScanner());
            map.put(NodeKind.KEYWORD_OBJECT, factory.getKeywordObjectScanner());
            map.put(NodeKind.KEYWORD_POSITIVE, factory.getKeywordPositiveScanner());
            map.put(NodeKind.KEYWORD_NEGATIVE, factory.getKeywordNegativeScanner());
            map.put(NodeKind.INDEXER_OPERATOR, factory.getIndexerOperatorScanner());
            map.put(NodeKind.SEPARATOR, factory.getSeparatorScanner());
            map.put(NodeKind.KEYWORD_IF, factory.getKeywordIfScanner());
            map.put(NodeKind.APPLY, factory.getApplyScanner());
            map.put(NodeKind.KEYWORD_MODULE, factory.getKeywordModuleScanner());
            map.put(NodeKind.KEYWORD_IMPORT, factory.getKeywordImportScanner());
            map.put(NodeKind.WILDCARD, factory.getWildcardScanner());
            map.put(NodeKind.KEYWORD_FROM, factory.getKeywordFromScanner());
            map.put(NodeKind.KEYWORD_AS, factory.getKeywordAsScanner());
            delegates = Collections.unmodifiableMap(new ConcurrentHashMap(map));
        }
    }
}

