/*
 * Decompiled with CFR 0.152.
 */
package org.sterling.source.scanner;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import org.sterling.SterlingException;
import org.sterling.source.exception.InvalidEscapeSequenceException;
import org.sterling.source.exception.ScannerException;
import org.sterling.source.exception.UnterminatedCharacterException;
import org.sterling.source.exception.UnterminatedStringException;
import org.sterling.source.scanner.InputReader;
import org.sterling.source.syntax.NodeKind;

public final class ScannerUtil {
    public static SterlingException invalidEscapeSequence(InputReader reader, NodeKind kind) {
        return new InvalidEscapeSequenceException("Invalid escape sequence in " + (Object)((Object)kind) + " [" + reader.getLocation() + "]");
    }

    public static SterlingException unexpectedInput(InputReader reader, Collection<NodeKind> expectedKinds) {
        while (!reader.expect('\u0000') && !reader.expect('\n') && Character.isWhitespace(reader.peek())) {
            reader.skip();
        }
        ScannerException exception = new ScannerException("Unexpected " + ScannerUtil.getName(reader) + " '" + ScannerUtil.getValue(reader) + "', expecting " + ScannerUtil.listKinds(expectedKinds) + " [" + reader.getLocation() + "]");
        reader.reject();
        return exception;
    }

    public static SterlingException unexpectedInput(InputReader reader, NodeKind ... expectedKinds) {
        return ScannerUtil.unexpectedInput(reader, Arrays.asList(expectedKinds));
    }

    public static SterlingException unterminatedCharacter(InputReader reader, NodeKind kind) {
        return new UnterminatedCharacterException("Unterminated " + (Object)((Object)kind) + " [" + reader.getLocation() + "]");
    }

    public static SterlingException unterminatedString(InputReader reader, NodeKind kind) {
        return new UnterminatedStringException("Unterminated " + (Object)((Object)kind) + " [" + reader.getLocation() + "]");
    }

    private static String getName(InputReader reader) {
        char value = reader.peek();
        return value == '\u0000' ? "END OF INPUT" : Character.getName(value);
    }

    private static String getValue(InputReader reader) {
        char value = reader.peek();
        if (' ' != value && (Character.isWhitespace(value) || Character.isISOControl(value))) {
            return "";
        }
        return String.valueOf(value);
    }

    private static String listKinds(Collection<NodeKind> kinds) {
        StringBuilder builder = new StringBuilder();
        ArrayDeque<NodeKind> queue = new ArrayDeque<NodeKind>(kinds);
        builder.append(queue.pop());
        while (queue.size() > 1) {
            builder.append(", ");
            builder.append(queue.pop());
        }
        if (queue.size() > 0) {
            builder.append(" or ");
            builder.append(queue.pop());
        }
        return builder.toString();
    }

    private ScannerUtil() {
    }
}

